/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.PackageIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInstanceProfileRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, UpdateInstanceProfileRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateInstanceProfileRequest.getter(UpdateInstanceProfileRequest::arn)).setter(UpdateInstanceProfileRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateInstanceProfileRequest.getter(UpdateInstanceProfileRequest::name)).setter(UpdateInstanceProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateInstanceProfileRequest.getter(UpdateInstanceProfileRequest::description)).setter(UpdateInstanceProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> PACKAGE_CLEANUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateInstanceProfileRequest.getter(UpdateInstanceProfileRequest::packageCleanup)).setter(UpdateInstanceProfileRequest.setter(Builder::packageCleanup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageCleanup").build()}).build();
    private static final SdkField<List<String>> EXCLUDE_APP_PACKAGES_FROM_CLEANUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateInstanceProfileRequest.getter(UpdateInstanceProfileRequest::excludeAppPackagesFromCleanup)).setter(UpdateInstanceProfileRequest.setter(Builder::excludeAppPackagesFromCleanup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeAppPackagesFromCleanup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> REBOOT_AFTER_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateInstanceProfileRequest.getter(UpdateInstanceProfileRequest::rebootAfterUse)).setter(UpdateInstanceProfileRequest.setter(Builder::rebootAfterUse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rebootAfterUse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, PACKAGE_CLEANUP_FIELD, EXCLUDE_APP_PACKAGES_FROM_CLEANUP_FIELD, REBOOT_AFTER_USE_FIELD));
    private final String arn;
    private final String name;
    private final String description;
    private final Boolean packageCleanup;
    private final List<String> excludeAppPackagesFromCleanup;
    private final Boolean rebootAfterUse;

    private UpdateInstanceProfileRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.packageCleanup = builder.packageCleanup;
        this.excludeAppPackagesFromCleanup = builder.excludeAppPackagesFromCleanup;
        this.rebootAfterUse = builder.rebootAfterUse;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Boolean packageCleanup() {
        return this.packageCleanup;
    }

    public List<String> excludeAppPackagesFromCleanup() {
        return this.excludeAppPackagesFromCleanup;
    }

    public Boolean rebootAfterUse() {
        return this.rebootAfterUse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageCleanup());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeAppPackagesFromCleanup());
        hashCode = 31 * hashCode + Objects.hashCode(this.rebootAfterUse());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceProfileRequest)) {
            return false;
        }
        UpdateInstanceProfileRequest other = (UpdateInstanceProfileRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.packageCleanup(), other.packageCleanup()) && Objects.equals(this.excludeAppPackagesFromCleanup(), other.excludeAppPackagesFromCleanup()) && Objects.equals(this.rebootAfterUse(), other.rebootAfterUse());
    }

    public String toString() {
        return ToString.builder((String)"UpdateInstanceProfileRequest").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("PackageCleanup", (Object)this.packageCleanup()).add("ExcludeAppPackagesFromCleanup", this.excludeAppPackagesFromCleanup()).add("RebootAfterUse", (Object)this.rebootAfterUse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "packageCleanup": {
                return Optional.ofNullable(clazz.cast(this.packageCleanup()));
            }
            case "excludeAppPackagesFromCleanup": {
                return Optional.ofNullable(clazz.cast(this.excludeAppPackagesFromCleanup()));
            }
            case "rebootAfterUse": {
                return Optional.ofNullable(clazz.cast(this.rebootAfterUse()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInstanceProfileRequest, T> g) {
        return obj -> g.apply((UpdateInstanceProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private Boolean packageCleanup;
        private List<String> excludeAppPackagesFromCleanup = DefaultSdkAutoConstructList.getInstance();
        private Boolean rebootAfterUse;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstanceProfileRequest model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.packageCleanup(model.packageCleanup);
            this.excludeAppPackagesFromCleanup(model.excludeAppPackagesFromCleanup);
            this.rebootAfterUse(model.rebootAfterUse);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getPackageCleanup() {
            return this.packageCleanup;
        }

        @Override
        public final Builder packageCleanup(Boolean packageCleanup) {
            this.packageCleanup = packageCleanup;
            return this;
        }

        public final void setPackageCleanup(Boolean packageCleanup) {
            this.packageCleanup = packageCleanup;
        }

        public final Collection<String> getExcludeAppPackagesFromCleanup() {
            return this.excludeAppPackagesFromCleanup;
        }

        @Override
        public final Builder excludeAppPackagesFromCleanup(Collection<String> excludeAppPackagesFromCleanup) {
            this.excludeAppPackagesFromCleanup = PackageIdsCopier.copy(excludeAppPackagesFromCleanup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeAppPackagesFromCleanup(String ... excludeAppPackagesFromCleanup) {
            this.excludeAppPackagesFromCleanup(Arrays.asList(excludeAppPackagesFromCleanup));
            return this;
        }

        public final void setExcludeAppPackagesFromCleanup(Collection<String> excludeAppPackagesFromCleanup) {
            this.excludeAppPackagesFromCleanup = PackageIdsCopier.copy(excludeAppPackagesFromCleanup);
        }

        public final Boolean getRebootAfterUse() {
            return this.rebootAfterUse;
        }

        @Override
        public final Builder rebootAfterUse(Boolean rebootAfterUse) {
            this.rebootAfterUse = rebootAfterUse;
            return this;
        }

        public final void setRebootAfterUse(Boolean rebootAfterUse) {
            this.rebootAfterUse = rebootAfterUse;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInstanceProfileRequest build() {
            return new UpdateInstanceProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInstanceProfileRequest> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder packageCleanup(Boolean var1);

        public Builder excludeAppPackagesFromCleanup(Collection<String> var1);

        public Builder excludeAppPackagesFromCleanup(String ... var1);

        public Builder rebootAfterUse(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

