/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse;
import software.amazon.awssdk.services.devicefarm.model.OfferingTransaction;

public class ListOfferingTransactionsIterable
implements SdkIterable<ListOfferingTransactionsResponse> {
    private final DeviceFarmClient client;
    private final ListOfferingTransactionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOfferingTransactionsIterable(DeviceFarmClient client, ListOfferingTransactionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOfferingTransactionsResponseFetcher();
    }

    public Iterator<ListOfferingTransactionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OfferingTransaction> offeringTransactions() {
        Function<ListOfferingTransactionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.offeringTransactions() != null) {
                return response.offeringTransactions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListOfferingTransactionsIterable resume(ListOfferingTransactionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListOfferingTransactionsIterable(this.client, (ListOfferingTransactionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListOfferingTransactionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListOfferingTransactionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListOfferingTransactionsResponseFetcher
    implements SyncPageFetcher<ListOfferingTransactionsResponse> {
        private ListOfferingTransactionsResponseFetcher() {
        }

        public boolean hasNextPage(ListOfferingTransactionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOfferingTransactionsResponse nextPage(ListOfferingTransactionsResponse previousPage) {
            if (previousPage == null) {
                return ListOfferingTransactionsIterable.this.client.listOfferingTransactions(ListOfferingTransactionsIterable.this.firstRequest);
            }
            return ListOfferingTransactionsIterable.this.client.listOfferingTransactions((ListOfferingTransactionsRequest)((Object)ListOfferingTransactionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

