/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.Sample;
import software.amazon.awssdk.services.devicefarm.model.SamplesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSamplesResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListSamplesResponse> {
    private static final SdkField<List<Sample>> SAMPLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("samples").getter(ListSamplesResponse.getter(ListSamplesResponse::samples)).setter(ListSamplesResponse.setter(Builder::samples)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samples").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Sample::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSamplesResponse.getter(ListSamplesResponse::nextToken)).setter(ListSamplesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("samples", SAMPLES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<Sample> samples;
    private final String nextToken;

    private ListSamplesResponse(BuilderImpl builder) {
        super(builder);
        this.samples = builder.samples;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSamples() {
        return this.samples != null && !(this.samples instanceof SdkAutoConstructList);
    }

    public final List<Sample> samples() {
        return this.samples;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSamples() ? this.samples() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSamplesResponse)) {
            return false;
        }
        ListSamplesResponse other = (ListSamplesResponse)((Object)obj);
        return this.hasSamples() == other.hasSamples() && Objects.equals(this.samples(), other.samples()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSamplesResponse").add("Samples", this.hasSamples() ? this.samples() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "samples": {
                return Optional.ofNullable(clazz.cast(this.samples()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSamplesResponse, T> g) {
        return obj -> g.apply((ListSamplesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<Sample> samples = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSamplesResponse model) {
            super(model);
            this.samples(model.samples);
            this.nextToken(model.nextToken);
        }

        public final List<Sample.Builder> getSamples() {
            List<Sample.Builder> result = SamplesCopier.copyToBuilder(this.samples);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSamples(Collection<Sample.BuilderImpl> samples) {
            this.samples = SamplesCopier.copyFromBuilder(samples);
        }

        @Override
        public final Builder samples(Collection<Sample> samples) {
            this.samples = SamplesCopier.copy(samples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samples(Sample ... samples) {
            this.samples(Arrays.asList(samples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samples(Consumer<Sample.Builder> ... samples) {
            this.samples(Stream.of(samples).map(c -> (Sample)((Sample.Builder)Sample.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSamplesResponse build() {
            return new ListSamplesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSamplesResponse> {
        public Builder samples(Collection<Sample> var1);

        public Builder samples(Sample ... var1);

        public Builder samples(Consumer<Sample.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

