/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestGridSessionsRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, ListTestGridSessionsRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectArn").getter(ListTestGridSessionsRequest.getter(ListTestGridSessionsRequest::projectArn)).setter(ListTestGridSessionsRequest.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListTestGridSessionsRequest.getter(ListTestGridSessionsRequest::statusAsString)).setter(ListTestGridSessionsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimeAfter").getter(ListTestGridSessionsRequest.getter(ListTestGridSessionsRequest::creationTimeAfter)).setter(ListTestGridSessionsRequest.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimeAfter").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimeBefore").getter(ListTestGridSessionsRequest.getter(ListTestGridSessionsRequest::creationTimeBefore)).setter(ListTestGridSessionsRequest.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimeBefore").build()}).build();
    private static final SdkField<Instant> END_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTimeAfter").getter(ListTestGridSessionsRequest.getter(ListTestGridSessionsRequest::endTimeAfter)).setter(ListTestGridSessionsRequest.setter(Builder::endTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeAfter").build()}).build();
    private static final SdkField<Instant> END_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTimeBefore").getter(ListTestGridSessionsRequest.getter(ListTestGridSessionsRequest::endTimeBefore)).setter(ListTestGridSessionsRequest.setter(Builder::endTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeBefore").build()}).build();
    private static final SdkField<Integer> MAX_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResult").getter(ListTestGridSessionsRequest.getter(ListTestGridSessionsRequest::maxResult)).setter(ListTestGridSessionsRequest.setter(Builder::maxResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResult").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestGridSessionsRequest.getter(ListTestGridSessionsRequest::nextToken)).setter(ListTestGridSessionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, STATUS_FIELD, CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, END_TIME_AFTER_FIELD, END_TIME_BEFORE_FIELD, MAX_RESULT_FIELD, NEXT_TOKEN_FIELD));
    private final String projectArn;
    private final String status;
    private final Instant creationTimeAfter;
    private final Instant creationTimeBefore;
    private final Instant endTimeAfter;
    private final Instant endTimeBefore;
    private final Integer maxResult;
    private final String nextToken;

    private ListTestGridSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.status = builder.status;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.endTimeAfter = builder.endTimeAfter;
        this.endTimeBefore = builder.endTimeBefore;
        this.maxResult = builder.maxResult;
        this.nextToken = builder.nextToken;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final TestGridSessionStatus status() {
        return TestGridSessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public final Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public final Instant endTimeAfter() {
        return this.endTimeAfter;
    }

    public final Instant endTimeBefore() {
        return this.endTimeBefore;
    }

    public final Integer maxResult() {
        return this.maxResult;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestGridSessionsRequest)) {
            return false;
        }
        ListTestGridSessionsRequest other = (ListTestGridSessionsRequest)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.endTimeAfter(), other.endTimeAfter()) && Objects.equals(this.endTimeBefore(), other.endTimeBefore()) && Objects.equals(this.maxResult(), other.maxResult()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTestGridSessionsRequest").add("ProjectArn", (Object)this.projectArn()).add("Status", (Object)this.statusAsString()).add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("EndTimeAfter", (Object)this.endTimeAfter()).add("EndTimeBefore", (Object)this.endTimeBefore()).add("MaxResult", (Object)this.maxResult()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "creationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
            case "endTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.endTimeAfter()));
            }
            case "endTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.endTimeBefore()));
            }
            case "maxResult": {
                return Optional.ofNullable(clazz.cast(this.maxResult()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestGridSessionsRequest, T> g) {
        return obj -> g.apply((ListTestGridSessionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String projectArn;
        private String status;
        private Instant creationTimeAfter;
        private Instant creationTimeBefore;
        private Instant endTimeAfter;
        private Instant endTimeBefore;
        private Integer maxResult;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestGridSessionsRequest model) {
            super(model);
            this.projectArn(model.projectArn);
            this.status(model.status);
            this.creationTimeAfter(model.creationTimeAfter);
            this.creationTimeBefore(model.creationTimeBefore);
            this.endTimeAfter(model.endTimeAfter);
            this.endTimeBefore(model.endTimeBefore);
            this.maxResult(model.maxResult);
            this.nextToken(model.nextToken);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestGridSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getEndTimeAfter() {
            return this.endTimeAfter;
        }

        public final void setEndTimeAfter(Instant endTimeAfter) {
            this.endTimeAfter = endTimeAfter;
        }

        @Override
        public final Builder endTimeAfter(Instant endTimeAfter) {
            this.endTimeAfter = endTimeAfter;
            return this;
        }

        public final Instant getEndTimeBefore() {
            return this.endTimeBefore;
        }

        public final void setEndTimeBefore(Instant endTimeBefore) {
            this.endTimeBefore = endTimeBefore;
        }

        @Override
        public final Builder endTimeBefore(Instant endTimeBefore) {
            this.endTimeBefore = endTimeBefore;
            return this;
        }

        public final Integer getMaxResult() {
            return this.maxResult;
        }

        public final void setMaxResult(Integer maxResult) {
            this.maxResult = maxResult;
        }

        @Override
        public final Builder maxResult(Integer maxResult) {
            this.maxResult = maxResult;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTestGridSessionsRequest build() {
            return new ListTestGridSessionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestGridSessionsRequest> {
        public Builder projectArn(String var1);

        public Builder status(String var1);

        public Builder status(TestGridSessionStatus var1);

        public Builder creationTimeAfter(Instant var1);

        public Builder creationTimeBefore(Instant var1);

        public Builder endTimeAfter(Instant var1);

        public Builder endTimeBefore(Instant var1);

        public Builder maxResult(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

