/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.Device;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResult;
import software.amazon.awssdk.services.devicefarm.model.ProblemDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Problem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Problem> {
    private static final SdkField<ProblemDetail> RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Problem.getter(Problem::run)).setter(Problem.setter(Builder::run)).constructor(ProblemDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("run").build()}).build();
    private static final SdkField<ProblemDetail> JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Problem.getter(Problem::job)).setter(Problem.setter(Builder::job)).constructor(ProblemDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("job").build()}).build();
    private static final SdkField<ProblemDetail> SUITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Problem.getter(Problem::suite)).setter(Problem.setter(Builder::suite)).constructor(ProblemDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suite").build()}).build();
    private static final SdkField<ProblemDetail> TEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Problem.getter(Problem::test)).setter(Problem.setter(Builder::test)).constructor(ProblemDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("test").build()}).build();
    private static final SdkField<Device> DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Problem.getter(Problem::device)).setter(Problem.setter(Builder::device)).constructor(Device::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()}).build();
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Problem.getter(Problem::resultAsString)).setter(Problem.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Problem.getter(Problem::message)).setter(Problem.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_FIELD, JOB_FIELD, SUITE_FIELD, TEST_FIELD, DEVICE_FIELD, RESULT_FIELD, MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final ProblemDetail run;
    private final ProblemDetail job;
    private final ProblemDetail suite;
    private final ProblemDetail test;
    private final Device device;
    private final String result;
    private final String message;

    private Problem(BuilderImpl builder) {
        this.run = builder.run;
        this.job = builder.job;
        this.suite = builder.suite;
        this.test = builder.test;
        this.device = builder.device;
        this.result = builder.result;
        this.message = builder.message;
    }

    public ProblemDetail run() {
        return this.run;
    }

    public ProblemDetail job() {
        return this.job;
    }

    public ProblemDetail suite() {
        return this.suite;
    }

    public ProblemDetail test() {
        return this.test;
    }

    public Device device() {
        return this.device;
    }

    public ExecutionResult result() {
        return ExecutionResult.fromValue(this.result);
    }

    public String resultAsString() {
        return this.result;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.run());
        hashCode = 31 * hashCode + Objects.hashCode(this.job());
        hashCode = 31 * hashCode + Objects.hashCode(this.suite());
        hashCode = 31 * hashCode + Objects.hashCode(this.test());
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Problem)) {
            return false;
        }
        Problem other = (Problem)obj;
        return Objects.equals(this.run(), other.run()) && Objects.equals(this.job(), other.job()) && Objects.equals(this.suite(), other.suite()) && Objects.equals(this.test(), other.test()) && Objects.equals(this.device(), other.device()) && Objects.equals(this.resultAsString(), other.resultAsString()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        return ToString.builder((String)"Problem").add("Run", (Object)this.run()).add("Job", (Object)this.job()).add("Suite", (Object)this.suite()).add("Test", (Object)this.test()).add("Device", (Object)this.device()).add("Result", (Object)this.resultAsString()).add("Message", (Object)this.message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "run": {
                return Optional.ofNullable(clazz.cast(this.run()));
            }
            case "job": {
                return Optional.ofNullable(clazz.cast(this.job()));
            }
            case "suite": {
                return Optional.ofNullable(clazz.cast(this.suite()));
            }
            case "test": {
                return Optional.ofNullable(clazz.cast(this.test()));
            }
            case "device": {
                return Optional.ofNullable(clazz.cast(this.device()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.resultAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Problem, T> g) {
        return obj -> g.apply((Problem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ProblemDetail run;
        private ProblemDetail job;
        private ProblemDetail suite;
        private ProblemDetail test;
        private Device device;
        private String result;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(Problem model) {
            this.run(model.run);
            this.job(model.job);
            this.suite(model.suite);
            this.test(model.test);
            this.device(model.device);
            this.result(model.result);
            this.message(model.message);
        }

        public final ProblemDetail.Builder getRun() {
            return this.run != null ? this.run.toBuilder() : null;
        }

        @Override
        public final Builder run(ProblemDetail run) {
            this.run = run;
            return this;
        }

        public final void setRun(ProblemDetail.BuilderImpl run) {
            this.run = run != null ? run.build() : null;
        }

        public final ProblemDetail.Builder getJob() {
            return this.job != null ? this.job.toBuilder() : null;
        }

        @Override
        public final Builder job(ProblemDetail job) {
            this.job = job;
            return this;
        }

        public final void setJob(ProblemDetail.BuilderImpl job) {
            this.job = job != null ? job.build() : null;
        }

        public final ProblemDetail.Builder getSuite() {
            return this.suite != null ? this.suite.toBuilder() : null;
        }

        @Override
        public final Builder suite(ProblemDetail suite) {
            this.suite = suite;
            return this;
        }

        public final void setSuite(ProblemDetail.BuilderImpl suite) {
            this.suite = suite != null ? suite.build() : null;
        }

        public final ProblemDetail.Builder getTest() {
            return this.test != null ? this.test.toBuilder() : null;
        }

        @Override
        public final Builder test(ProblemDetail test) {
            this.test = test;
            return this;
        }

        public final void setTest(ProblemDetail.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        public final Device.Builder getDevice() {
            return this.device != null ? this.device.toBuilder() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        public final String getResult() {
            return this.result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public Problem build() {
            return new Problem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Problem> {
        public Builder run(ProblemDetail var1);

        default public Builder run(Consumer<ProblemDetail.Builder> run) {
            return this.run((ProblemDetail)((ProblemDetail.Builder)ProblemDetail.builder().applyMutation(run)).build());
        }

        public Builder job(ProblemDetail var1);

        default public Builder job(Consumer<ProblemDetail.Builder> job) {
            return this.job((ProblemDetail)((ProblemDetail.Builder)ProblemDetail.builder().applyMutation(job)).build());
        }

        public Builder suite(ProblemDetail var1);

        default public Builder suite(Consumer<ProblemDetail.Builder> suite) {
            return this.suite((ProblemDetail)((ProblemDetail.Builder)ProblemDetail.builder().applyMutation(suite)).build());
        }

        public Builder test(ProblemDetail var1);

        default public Builder test(Consumer<ProblemDetail.Builder> test) {
            return this.test((ProblemDetail)((ProblemDetail.Builder)ProblemDetail.builder().applyMutation(test)).build());
        }

        public Builder device(Device var1);

        default public Builder device(Consumer<Device.Builder> device) {
            return this.device((Device)((Device.Builder)Device.builder().applyMutation(device)).build());
        }

        public Builder result(String var1);

        public Builder result(ExecutionResult var1);

        public Builder message(String var1);
    }
}

