/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession;
import software.amazon.awssdk.services.devicefarm.model.RemoteAccessSessionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRemoteAccessSessionsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListRemoteAccessSessionsResponse> {
    private static final SdkField<List<RemoteAccessSession>> REMOTE_ACCESS_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("remoteAccessSessions").getter(ListRemoteAccessSessionsResponse.getter(ListRemoteAccessSessionsResponse::remoteAccessSessions)).setter(ListRemoteAccessSessionsResponse.setter(Builder::remoteAccessSessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessSessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemoteAccessSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRemoteAccessSessionsResponse.getter(ListRemoteAccessSessionsResponse::nextToken)).setter(ListRemoteAccessSessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOTE_ACCESS_SESSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<RemoteAccessSession> remoteAccessSessions;
    private final String nextToken;

    private ListRemoteAccessSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.remoteAccessSessions = builder.remoteAccessSessions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRemoteAccessSessions() {
        return this.remoteAccessSessions != null && !(this.remoteAccessSessions instanceof SdkAutoConstructList);
    }

    public final List<RemoteAccessSession> remoteAccessSessions() {
        return this.remoteAccessSessions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoteAccessSessions() ? this.remoteAccessSessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRemoteAccessSessionsResponse)) {
            return false;
        }
        ListRemoteAccessSessionsResponse other = (ListRemoteAccessSessionsResponse)((Object)obj);
        return this.hasRemoteAccessSessions() == other.hasRemoteAccessSessions() && Objects.equals(this.remoteAccessSessions(), other.remoteAccessSessions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRemoteAccessSessionsResponse").add("RemoteAccessSessions", this.hasRemoteAccessSessions() ? this.remoteAccessSessions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "remoteAccessSessions": {
                return Optional.ofNullable(clazz.cast(this.remoteAccessSessions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRemoteAccessSessionsResponse, T> g) {
        return obj -> g.apply((ListRemoteAccessSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<RemoteAccessSession> remoteAccessSessions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRemoteAccessSessionsResponse model) {
            super(model);
            this.remoteAccessSessions(model.remoteAccessSessions);
            this.nextToken(model.nextToken);
        }

        public final List<RemoteAccessSession.Builder> getRemoteAccessSessions() {
            List<RemoteAccessSession.Builder> result = RemoteAccessSessionsCopier.copyToBuilder(this.remoteAccessSessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoteAccessSessions(Collection<RemoteAccessSession.BuilderImpl> remoteAccessSessions) {
            this.remoteAccessSessions = RemoteAccessSessionsCopier.copyFromBuilder(remoteAccessSessions);
        }

        @Override
        @Transient
        public final Builder remoteAccessSessions(Collection<RemoteAccessSession> remoteAccessSessions) {
            this.remoteAccessSessions = RemoteAccessSessionsCopier.copy(remoteAccessSessions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder remoteAccessSessions(RemoteAccessSession ... remoteAccessSessions) {
            this.remoteAccessSessions(Arrays.asList(remoteAccessSessions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder remoteAccessSessions(Consumer<RemoteAccessSession.Builder> ... remoteAccessSessions) {
            this.remoteAccessSessions(Stream.of(remoteAccessSessions).map(c -> (RemoteAccessSession)((RemoteAccessSession.Builder)RemoteAccessSession.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRemoteAccessSessionsResponse build() {
            return new ListRemoteAccessSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRemoteAccessSessionsResponse> {
        public Builder remoteAccessSessions(Collection<RemoteAccessSession> var1);

        public Builder remoteAccessSessions(RemoteAccessSession ... var1);

        public Builder remoteAccessSessions(Consumer<RemoteAccessSession.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

