/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum DeviceFilterAttribute {
    ARN("ARN"),

    PLATFORM("PLATFORM"),

    OS_VERSION("OS_VERSION"),

    MODEL("MODEL"),

    AVAILABILITY("AVAILABILITY"),

    FORM_FACTOR("FORM_FACTOR"),

    MANUFACTURER("MANUFACTURER"),

    REMOTE_ACCESS_ENABLED("REMOTE_ACCESS_ENABLED"),

    REMOTE_DEBUG_ENABLED("REMOTE_DEBUG_ENABLED"),

    INSTANCE_ARN("INSTANCE_ARN"),

    INSTANCE_LABELS("INSTANCE_LABELS"),

    FLEET_TYPE("FLEET_TYPE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeviceFilterAttribute(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DeviceFilterAttribute corresponding to the value
     */
    public static DeviceFilterAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeviceFilterAttribute.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DeviceFilterAttribute}s
     */
    public static Set<DeviceFilterAttribute> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
