/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.TestGridSessionArtifact;
import software.amazon.awssdk.services.devicefarm.model.TestGridSessionArtifactsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestGridSessionArtifactsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListTestGridSessionArtifactsResponse> {
    private static final SdkField<List<TestGridSessionArtifact>> ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("artifacts").getter(ListTestGridSessionArtifactsResponse.getter(ListTestGridSessionArtifactsResponse::artifacts)).setter(ListTestGridSessionArtifactsResponse.setter(Builder::artifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestGridSessionArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestGridSessionArtifactsResponse.getter(ListTestGridSessionArtifactsResponse::nextToken)).setter(ListTestGridSessionArtifactsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TestGridSessionArtifact> artifacts;
    private final String nextToken;

    private ListTestGridSessionArtifactsResponse(BuilderImpl builder) {
        super(builder);
        this.artifacts = builder.artifacts;
        this.nextToken = builder.nextToken;
    }

    public boolean hasArtifacts() {
        return this.artifacts != null && !(this.artifacts instanceof SdkAutoConstructList);
    }

    public List<TestGridSessionArtifact> artifacts() {
        return this.artifacts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArtifacts() ? this.artifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestGridSessionArtifactsResponse)) {
            return false;
        }
        ListTestGridSessionArtifactsResponse other = (ListTestGridSessionArtifactsResponse)((Object)obj);
        return this.hasArtifacts() == other.hasArtifacts() && Objects.equals(this.artifacts(), other.artifacts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTestGridSessionArtifactsResponse").add("Artifacts", this.hasArtifacts() ? this.artifacts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "artifacts": {
                return Optional.ofNullable(clazz.cast(this.artifacts()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestGridSessionArtifactsResponse, T> g) {
        return obj -> g.apply((ListTestGridSessionArtifactsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<TestGridSessionArtifact> artifacts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestGridSessionArtifactsResponse model) {
            super(model);
            this.artifacts(model.artifacts);
            this.nextToken(model.nextToken);
        }

        public final Collection<TestGridSessionArtifact.Builder> getArtifacts() {
            if (this.artifacts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.artifacts != null ? (Collection)this.artifacts.stream().map(TestGridSessionArtifact::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder artifacts(Collection<TestGridSessionArtifact> artifacts) {
            this.artifacts = TestGridSessionArtifactsCopier.copy(artifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(TestGridSessionArtifact ... artifacts) {
            this.artifacts(Arrays.asList(artifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(Consumer<TestGridSessionArtifact.Builder> ... artifacts) {
            this.artifacts(Stream.of(artifacts).map(c -> (TestGridSessionArtifact)((TestGridSessionArtifact.Builder)TestGridSessionArtifact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setArtifacts(Collection<TestGridSessionArtifact.BuilderImpl> artifacts) {
            this.artifacts = TestGridSessionArtifactsCopier.copyFromBuilder(artifacts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTestGridSessionArtifactsResponse build() {
            return new ListTestGridSessionArtifactsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestGridSessionArtifactsResponse> {
        public Builder artifacts(Collection<TestGridSessionArtifact> var1);

        public Builder artifacts(TestGridSessionArtifact ... var1);

        public Builder artifacts(Consumer<TestGridSessionArtifact.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

