/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.TestGridSession;
import software.amazon.awssdk.services.devicefarm.model.TestGridSessionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestGridSessionsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListTestGridSessionsResponse> {
    private static final SdkField<List<TestGridSession>> TEST_GRID_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testGridSessions").getter(ListTestGridSessionsResponse.getter(ListTestGridSessionsResponse::testGridSessions)).setter(ListTestGridSessionsResponse.setter(Builder::testGridSessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testGridSessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestGridSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestGridSessionsResponse.getter(ListTestGridSessionsResponse::nextToken)).setter(ListTestGridSessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_GRID_SESSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TestGridSession> testGridSessions;
    private final String nextToken;

    private ListTestGridSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.testGridSessions = builder.testGridSessions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTestGridSessions() {
        return this.testGridSessions != null && !(this.testGridSessions instanceof SdkAutoConstructList);
    }

    public List<TestGridSession> testGridSessions() {
        return this.testGridSessions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testGridSessions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestGridSessionsResponse)) {
            return false;
        }
        ListTestGridSessionsResponse other = (ListTestGridSessionsResponse)((Object)obj);
        return Objects.equals(this.testGridSessions(), other.testGridSessions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTestGridSessionsResponse").add("TestGridSessions", this.testGridSessions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testGridSessions": {
                return Optional.ofNullable(clazz.cast(this.testGridSessions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestGridSessionsResponse, T> g) {
        return obj -> g.apply((ListTestGridSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<TestGridSession> testGridSessions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestGridSessionsResponse model) {
            super(model);
            this.testGridSessions(model.testGridSessions);
            this.nextToken(model.nextToken);
        }

        public final Collection<TestGridSession.Builder> getTestGridSessions() {
            return this.testGridSessions != null ? (Collection)this.testGridSessions.stream().map(TestGridSession::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder testGridSessions(Collection<TestGridSession> testGridSessions) {
            this.testGridSessions = TestGridSessionsCopier.copy(testGridSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testGridSessions(TestGridSession ... testGridSessions) {
            this.testGridSessions(Arrays.asList(testGridSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testGridSessions(Consumer<TestGridSession.Builder> ... testGridSessions) {
            this.testGridSessions(Stream.of(testGridSessions).map(c -> (TestGridSession)((TestGridSession.Builder)TestGridSession.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTestGridSessions(Collection<TestGridSession.BuilderImpl> testGridSessions) {
            this.testGridSessions = TestGridSessionsCopier.copyFromBuilder(testGridSessions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTestGridSessionsResponse build() {
            return new ListTestGridSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestGridSessionsResponse> {
        public Builder testGridSessions(Collection<TestGridSession> var1);

        public Builder testGridSessions(TestGridSession ... var1);

        public Builder testGridSessions(Consumer<TestGridSession.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

