/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.AmazonResourceNamesCopier;
import software.amazon.awssdk.services.devicefarm.model.BillingMethod;
import software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths;
import software.amazon.awssdk.services.devicefarm.model.Location;
import software.amazon.awssdk.services.devicefarm.model.Radios;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleRunConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduleRunConfiguration> {
    private static final SdkField<String> EXTRA_DATA_PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("extraDataPackageArn").getter(ScheduleRunConfiguration.getter(ScheduleRunConfiguration::extraDataPackageArn)).setter(ScheduleRunConfiguration.setter(Builder::extraDataPackageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraDataPackageArn").build()}).build();
    private static final SdkField<String> NETWORK_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkProfileArn").getter(ScheduleRunConfiguration.getter(ScheduleRunConfiguration::networkProfileArn)).setter(ScheduleRunConfiguration.setter(Builder::networkProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkProfileArn").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(ScheduleRunConfiguration.getter(ScheduleRunConfiguration::locale)).setter(ScheduleRunConfiguration.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final SdkField<Location> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(ScheduleRunConfiguration.getter(ScheduleRunConfiguration::location)).setter(ScheduleRunConfiguration.setter(Builder::location)).constructor(Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<List<String>> VPCE_CONFIGURATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpceConfigurationArns").getter(ScheduleRunConfiguration.getter(ScheduleRunConfiguration::vpceConfigurationArns)).setter(ScheduleRunConfiguration.setter(Builder::vpceConfigurationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfigurationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CustomerArtifactPaths> CUSTOMER_ARTIFACT_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customerArtifactPaths").getter(ScheduleRunConfiguration.getter(ScheduleRunConfiguration::customerArtifactPaths)).setter(ScheduleRunConfiguration.setter(Builder::customerArtifactPaths)).constructor(CustomerArtifactPaths::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerArtifactPaths").build()}).build();
    private static final SdkField<Radios> RADIOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("radios").getter(ScheduleRunConfiguration.getter(ScheduleRunConfiguration::radios)).setter(ScheduleRunConfiguration.setter(Builder::radios)).constructor(Radios::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("radios").build()}).build();
    private static final SdkField<List<String>> AUXILIARY_APPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("auxiliaryApps").getter(ScheduleRunConfiguration.getter(ScheduleRunConfiguration::auxiliaryApps)).setter(ScheduleRunConfiguration.setter(Builder::auxiliaryApps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auxiliaryApps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BILLING_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingMethod").getter(ScheduleRunConfiguration.getter(ScheduleRunConfiguration::billingMethodAsString)).setter(ScheduleRunConfiguration.setter(Builder::billingMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTRA_DATA_PACKAGE_ARN_FIELD, NETWORK_PROFILE_ARN_FIELD, LOCALE_FIELD, LOCATION_FIELD, VPCE_CONFIGURATION_ARNS_FIELD, CUSTOMER_ARTIFACT_PATHS_FIELD, RADIOS_FIELD, AUXILIARY_APPS_FIELD, BILLING_METHOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String extraDataPackageArn;
    private final String networkProfileArn;
    private final String locale;
    private final Location location;
    private final List<String> vpceConfigurationArns;
    private final CustomerArtifactPaths customerArtifactPaths;
    private final Radios radios;
    private final List<String> auxiliaryApps;
    private final String billingMethod;

    private ScheduleRunConfiguration(BuilderImpl builder) {
        this.extraDataPackageArn = builder.extraDataPackageArn;
        this.networkProfileArn = builder.networkProfileArn;
        this.locale = builder.locale;
        this.location = builder.location;
        this.vpceConfigurationArns = builder.vpceConfigurationArns;
        this.customerArtifactPaths = builder.customerArtifactPaths;
        this.radios = builder.radios;
        this.auxiliaryApps = builder.auxiliaryApps;
        this.billingMethod = builder.billingMethod;
    }

    public String extraDataPackageArn() {
        return this.extraDataPackageArn;
    }

    public String networkProfileArn() {
        return this.networkProfileArn;
    }

    public String locale() {
        return this.locale;
    }

    public Location location() {
        return this.location;
    }

    public boolean hasVpceConfigurationArns() {
        return this.vpceConfigurationArns != null && !(this.vpceConfigurationArns instanceof SdkAutoConstructList);
    }

    public List<String> vpceConfigurationArns() {
        return this.vpceConfigurationArns;
    }

    public CustomerArtifactPaths customerArtifactPaths() {
        return this.customerArtifactPaths;
    }

    public Radios radios() {
        return this.radios;
    }

    public boolean hasAuxiliaryApps() {
        return this.auxiliaryApps != null && !(this.auxiliaryApps instanceof SdkAutoConstructList);
    }

    public List<String> auxiliaryApps() {
        return this.auxiliaryApps;
    }

    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(this.billingMethod);
    }

    public String billingMethodAsString() {
        return this.billingMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.extraDataPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpceConfigurationArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerArtifactPaths());
        hashCode = 31 * hashCode + Objects.hashCode(this.radios());
        hashCode = 31 * hashCode + Objects.hashCode(this.auxiliaryApps());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingMethodAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunConfiguration)) {
            return false;
        }
        ScheduleRunConfiguration other = (ScheduleRunConfiguration)obj;
        return Objects.equals(this.extraDataPackageArn(), other.extraDataPackageArn()) && Objects.equals(this.networkProfileArn(), other.networkProfileArn()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.vpceConfigurationArns(), other.vpceConfigurationArns()) && Objects.equals(this.customerArtifactPaths(), other.customerArtifactPaths()) && Objects.equals(this.radios(), other.radios()) && Objects.equals(this.auxiliaryApps(), other.auxiliaryApps()) && Objects.equals(this.billingMethodAsString(), other.billingMethodAsString());
    }

    public String toString() {
        return ToString.builder((String)"ScheduleRunConfiguration").add("ExtraDataPackageArn", (Object)this.extraDataPackageArn()).add("NetworkProfileArn", (Object)this.networkProfileArn()).add("Locale", (Object)this.locale()).add("Location", (Object)this.location()).add("VpceConfigurationArns", this.vpceConfigurationArns()).add("CustomerArtifactPaths", (Object)this.customerArtifactPaths()).add("Radios", (Object)this.radios()).add("AuxiliaryApps", this.auxiliaryApps()).add("BillingMethod", (Object)this.billingMethodAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "extraDataPackageArn": {
                return Optional.ofNullable(clazz.cast(this.extraDataPackageArn()));
            }
            case "networkProfileArn": {
                return Optional.ofNullable(clazz.cast(this.networkProfileArn()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "vpceConfigurationArns": {
                return Optional.ofNullable(clazz.cast(this.vpceConfigurationArns()));
            }
            case "customerArtifactPaths": {
                return Optional.ofNullable(clazz.cast(this.customerArtifactPaths()));
            }
            case "radios": {
                return Optional.ofNullable(clazz.cast(this.radios()));
            }
            case "auxiliaryApps": {
                return Optional.ofNullable(clazz.cast(this.auxiliaryApps()));
            }
            case "billingMethod": {
                return Optional.ofNullable(clazz.cast(this.billingMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleRunConfiguration, T> g) {
        return obj -> g.apply((ScheduleRunConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String extraDataPackageArn;
        private String networkProfileArn;
        private String locale;
        private Location location;
        private List<String> vpceConfigurationArns = DefaultSdkAutoConstructList.getInstance();
        private CustomerArtifactPaths customerArtifactPaths;
        private Radios radios;
        private List<String> auxiliaryApps = DefaultSdkAutoConstructList.getInstance();
        private String billingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunConfiguration model) {
            this.extraDataPackageArn(model.extraDataPackageArn);
            this.networkProfileArn(model.networkProfileArn);
            this.locale(model.locale);
            this.location(model.location);
            this.vpceConfigurationArns(model.vpceConfigurationArns);
            this.customerArtifactPaths(model.customerArtifactPaths);
            this.radios(model.radios);
            this.auxiliaryApps(model.auxiliaryApps);
            this.billingMethod(model.billingMethod);
        }

        public final String getExtraDataPackageArn() {
            return this.extraDataPackageArn;
        }

        @Override
        public final Builder extraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
            return this;
        }

        public final void setExtraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
        }

        public final String getNetworkProfileArn() {
            return this.networkProfileArn;
        }

        @Override
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final Location.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final Collection<String> getVpceConfigurationArns() {
            return this.vpceConfigurationArns;
        }

        @Override
        public final Builder vpceConfigurationArns(Collection<String> vpceConfigurationArns) {
            this.vpceConfigurationArns = AmazonResourceNamesCopier.copy(vpceConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpceConfigurationArns(String ... vpceConfigurationArns) {
            this.vpceConfigurationArns(Arrays.asList(vpceConfigurationArns));
            return this;
        }

        public final void setVpceConfigurationArns(Collection<String> vpceConfigurationArns) {
            this.vpceConfigurationArns = AmazonResourceNamesCopier.copy(vpceConfigurationArns);
        }

        public final CustomerArtifactPaths.Builder getCustomerArtifactPaths() {
            return this.customerArtifactPaths != null ? this.customerArtifactPaths.toBuilder() : null;
        }

        @Override
        public final Builder customerArtifactPaths(CustomerArtifactPaths customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths;
            return this;
        }

        public final void setCustomerArtifactPaths(CustomerArtifactPaths.BuilderImpl customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths != null ? customerArtifactPaths.build() : null;
        }

        public final Radios.Builder getRadios() {
            return this.radios != null ? this.radios.toBuilder() : null;
        }

        @Override
        public final Builder radios(Radios radios) {
            this.radios = radios;
            return this;
        }

        public final void setRadios(Radios.BuilderImpl radios) {
            this.radios = radios != null ? radios.build() : null;
        }

        public final Collection<String> getAuxiliaryApps() {
            return this.auxiliaryApps;
        }

        @Override
        public final Builder auxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auxiliaryApps(String ... auxiliaryApps) {
            this.auxiliaryApps(Arrays.asList(auxiliaryApps));
            return this;
        }

        public final void setAuxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
        }

        public final String getBillingMethod() {
            return this.billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod == null ? null : billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public ScheduleRunConfiguration build() {
            return new ScheduleRunConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduleRunConfiguration> {
        public Builder extraDataPackageArn(String var1);

        public Builder networkProfileArn(String var1);

        public Builder locale(String var1);

        public Builder location(Location var1);

        default public Builder location(Consumer<Location.Builder> location) {
            return this.location((Location)((Location.Builder)Location.builder().applyMutation(location)).build());
        }

        public Builder vpceConfigurationArns(Collection<String> var1);

        public Builder vpceConfigurationArns(String ... var1);

        public Builder customerArtifactPaths(CustomerArtifactPaths var1);

        default public Builder customerArtifactPaths(Consumer<CustomerArtifactPaths.Builder> customerArtifactPaths) {
            return this.customerArtifactPaths((CustomerArtifactPaths)((CustomerArtifactPaths.Builder)CustomerArtifactPaths.builder().applyMutation(customerArtifactPaths)).build());
        }

        public Builder radios(Radios var1);

        default public Builder radios(Consumer<Radios.Builder> radios) {
            return this.radios((Radios)((Radios.Builder)Radios.builder().applyMutation(radios)).build());
        }

        public Builder auxiliaryApps(Collection<String> var1);

        public Builder auxiliaryApps(String ... var1);

        public Builder billingMethod(String var1);

        public Builder billingMethod(BillingMethod var1);
    }
}

