/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVpceConfigurationRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, UpdateVpceConfigurationRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateVpceConfigurationRequest.getter(UpdateVpceConfigurationRequest::arn)).setter(UpdateVpceConfigurationRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> VPCE_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateVpceConfigurationRequest.getter(UpdateVpceConfigurationRequest::vpceConfigurationName)).setter(UpdateVpceConfigurationRequest.setter(Builder::vpceConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfigurationName").build()}).build();
    private static final SdkField<String> VPCE_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateVpceConfigurationRequest.getter(UpdateVpceConfigurationRequest::vpceServiceName)).setter(UpdateVpceConfigurationRequest.setter(Builder::vpceServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceServiceName").build()}).build();
    private static final SdkField<String> SERVICE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateVpceConfigurationRequest.getter(UpdateVpceConfigurationRequest::serviceDnsName)).setter(UpdateVpceConfigurationRequest.setter(Builder::serviceDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDnsName").build()}).build();
    private static final SdkField<String> VPCE_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateVpceConfigurationRequest.getter(UpdateVpceConfigurationRequest::vpceConfigurationDescription)).setter(UpdateVpceConfigurationRequest.setter(Builder::vpceConfigurationDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfigurationDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, VPCE_CONFIGURATION_NAME_FIELD, VPCE_SERVICE_NAME_FIELD, SERVICE_DNS_NAME_FIELD, VPCE_CONFIGURATION_DESCRIPTION_FIELD));
    private final String arn;
    private final String vpceConfigurationName;
    private final String vpceServiceName;
    private final String serviceDnsName;
    private final String vpceConfigurationDescription;

    private UpdateVpceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.vpceConfigurationName = builder.vpceConfigurationName;
        this.vpceServiceName = builder.vpceServiceName;
        this.serviceDnsName = builder.serviceDnsName;
        this.vpceConfigurationDescription = builder.vpceConfigurationDescription;
    }

    public String arn() {
        return this.arn;
    }

    public String vpceConfigurationName() {
        return this.vpceConfigurationName;
    }

    public String vpceServiceName() {
        return this.vpceServiceName;
    }

    public String serviceDnsName() {
        return this.serviceDnsName;
    }

    public String vpceConfigurationDescription() {
        return this.vpceConfigurationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpceConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpceServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpceConfigurationDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpceConfigurationRequest)) {
            return false;
        }
        UpdateVpceConfigurationRequest other = (UpdateVpceConfigurationRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.vpceConfigurationName(), other.vpceConfigurationName()) && Objects.equals(this.vpceServiceName(), other.vpceServiceName()) && Objects.equals(this.serviceDnsName(), other.serviceDnsName()) && Objects.equals(this.vpceConfigurationDescription(), other.vpceConfigurationDescription());
    }

    public String toString() {
        return ToString.builder((String)"UpdateVpceConfigurationRequest").add("Arn", (Object)this.arn()).add("VpceConfigurationName", (Object)this.vpceConfigurationName()).add("VpceServiceName", (Object)this.vpceServiceName()).add("ServiceDnsName", (Object)this.serviceDnsName()).add("VpceConfigurationDescription", (Object)this.vpceConfigurationDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "vpceConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.vpceConfigurationName()));
            }
            case "vpceServiceName": {
                return Optional.ofNullable(clazz.cast(this.vpceServiceName()));
            }
            case "serviceDnsName": {
                return Optional.ofNullable(clazz.cast(this.serviceDnsName()));
            }
            case "vpceConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.vpceConfigurationDescription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpceConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateVpceConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String vpceConfigurationName;
        private String vpceServiceName;
        private String serviceDnsName;
        private String vpceConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpceConfigurationRequest model) {
            super(model);
            this.arn(model.arn);
            this.vpceConfigurationName(model.vpceConfigurationName);
            this.vpceServiceName(model.vpceServiceName);
            this.serviceDnsName(model.serviceDnsName);
            this.vpceConfigurationDescription(model.vpceConfigurationDescription);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getVpceConfigurationName() {
            return this.vpceConfigurationName;
        }

        @Override
        public final Builder vpceConfigurationName(String vpceConfigurationName) {
            this.vpceConfigurationName = vpceConfigurationName;
            return this;
        }

        public final void setVpceConfigurationName(String vpceConfigurationName) {
            this.vpceConfigurationName = vpceConfigurationName;
        }

        public final String getVpceServiceName() {
            return this.vpceServiceName;
        }

        @Override
        public final Builder vpceServiceName(String vpceServiceName) {
            this.vpceServiceName = vpceServiceName;
            return this;
        }

        public final void setVpceServiceName(String vpceServiceName) {
            this.vpceServiceName = vpceServiceName;
        }

        public final String getServiceDnsName() {
            return this.serviceDnsName;
        }

        @Override
        public final Builder serviceDnsName(String serviceDnsName) {
            this.serviceDnsName = serviceDnsName;
            return this;
        }

        public final void setServiceDnsName(String serviceDnsName) {
            this.serviceDnsName = serviceDnsName;
        }

        public final String getVpceConfigurationDescription() {
            return this.vpceConfigurationDescription;
        }

        @Override
        public final Builder vpceConfigurationDescription(String vpceConfigurationDescription) {
            this.vpceConfigurationDescription = vpceConfigurationDescription;
            return this;
        }

        public final void setVpceConfigurationDescription(String vpceConfigurationDescription) {
            this.vpceConfigurationDescription = vpceConfigurationDescription;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVpceConfigurationRequest build() {
            return new UpdateVpceConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVpceConfigurationRequest> {
        public Builder arn(String var1);

        public Builder vpceConfigurationName(String var1);

        public Builder vpceServiceName(String var1);

        public Builder serviceDnsName(String var1);

        public Builder vpceConfigurationDescription(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

