/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkProfileResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<CreateNetworkProfileResponse.Builder, CreateNetworkProfileResponse> {
    private static final SdkField<NetworkProfile> NETWORK_PROFILE_FIELD = SdkField
            .<NetworkProfile> builder(MarshallingType.SDK_POJO).getter(getter(CreateNetworkProfileResponse::networkProfile))
            .setter(setter(Builder::networkProfile)).constructor(NetworkProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PROFILE_FIELD));

    private final NetworkProfile networkProfile;

    private CreateNetworkProfileResponse(BuilderImpl builder) {
        super(builder);
        this.networkProfile = builder.networkProfile;
    }

    /**
     * <p>
     * The network profile that is returned by the create network profile request.
     * </p>
     * 
     * @return The network profile that is returned by the create network profile request.
     */
    public NetworkProfile networkProfile() {
        return networkProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkProfile());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkProfileResponse)) {
            return false;
        }
        CreateNetworkProfileResponse other = (CreateNetworkProfileResponse) obj;
        return Objects.equals(networkProfile(), other.networkProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateNetworkProfileResponse").add("NetworkProfile", networkProfile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "networkProfile":
            return Optional.ofNullable(clazz.cast(networkProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkProfileResponse, T> g) {
        return obj -> g.apply((CreateNetworkProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateNetworkProfileResponse> {
        /**
         * <p>
         * The network profile that is returned by the create network profile request.
         * </p>
         * 
         * @param networkProfile
         *        The network profile that is returned by the create network profile request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfile(NetworkProfile networkProfile);

        /**
         * <p>
         * The network profile that is returned by the create network profile request.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkProfile.Builder} avoiding the need to
         * create one manually via {@link NetworkProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #networkProfile(NetworkProfile)}.
         * 
         * @param networkProfile
         *        a consumer that will call methods on {@link NetworkProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkProfile(NetworkProfile)
         */
        default Builder networkProfile(Consumer<NetworkProfile.Builder> networkProfile) {
            return networkProfile(NetworkProfile.builder().applyMutation(networkProfile).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private NetworkProfile networkProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkProfileResponse model) {
            super(model);
            networkProfile(model.networkProfile);
        }

        public final NetworkProfile.Builder getNetworkProfile() {
            return networkProfile != null ? networkProfile.toBuilder() : null;
        }

        @Override
        public final Builder networkProfile(NetworkProfile networkProfile) {
            this.networkProfile = networkProfile;
            return this;
        }

        public final void setNetworkProfile(NetworkProfile.BuilderImpl networkProfile) {
            this.networkProfile = networkProfile != null ? networkProfile.build() : null;
        }

        @Override
        public CreateNetworkProfileResponse build() {
            return new CreateNetworkProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
