/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNetworkProfilesResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListNetworkProfilesResponse.Builder, ListNetworkProfilesResponse> {
    private static final SdkField<List<NetworkProfile>> NETWORK_PROFILES_FIELD = SdkField
            .<List<NetworkProfile>> builder(MarshallingType.LIST)
            .getter(getter(ListNetworkProfilesResponse::networkProfiles))
            .setter(setter(Builder::networkProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListNetworkProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PROFILES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<NetworkProfile> networkProfiles;

    private final String nextToken;

    private ListNetworkProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.networkProfiles = builder.networkProfiles;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the NetworkProfiles property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkProfiles() {
        return networkProfiles != null && !(networkProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the available network profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkProfiles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the available network profiles.
     */
    public List<NetworkProfile> networkProfiles() {
        return networkProfiles;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworkProfilesResponse)) {
            return false;
        }
        ListNetworkProfilesResponse other = (ListNetworkProfilesResponse) obj;
        return Objects.equals(networkProfiles(), other.networkProfiles()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListNetworkProfilesResponse").add("NetworkProfiles", networkProfiles())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "networkProfiles":
            return Optional.ofNullable(clazz.cast(networkProfiles()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNetworkProfilesResponse, T> g) {
        return obj -> g.apply((ListNetworkProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListNetworkProfilesResponse> {
        /**
         * <p>
         * A list of the available network profiles.
         * </p>
         * 
         * @param networkProfiles
         *        A list of the available network profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfiles(Collection<NetworkProfile> networkProfiles);

        /**
         * <p>
         * A list of the available network profiles.
         * </p>
         * 
         * @param networkProfiles
         *        A list of the available network profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfiles(NetworkProfile... networkProfiles);

        /**
         * <p>
         * A list of the available network profiles.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkProfile>.Builder} avoiding the need
         * to create one manually via {@link List<NetworkProfile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkProfile>.Builder#build()} is called immediately and
         * its result is passed to {@link #networkProfiles(List<NetworkProfile>)}.
         * 
         * @param networkProfiles
         *        a consumer that will call methods on {@link List<NetworkProfile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkProfiles(List<NetworkProfile>)
         */
        Builder networkProfiles(Consumer<NetworkProfile.Builder>... networkProfiles);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<NetworkProfile> networkProfiles = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworkProfilesResponse model) {
            super(model);
            networkProfiles(model.networkProfiles);
            nextToken(model.nextToken);
        }

        public final Collection<NetworkProfile.Builder> getNetworkProfiles() {
            return networkProfiles != null ? networkProfiles.stream().map(NetworkProfile::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder networkProfiles(Collection<NetworkProfile> networkProfiles) {
            this.networkProfiles = NetworkProfilesCopier.copy(networkProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProfiles(NetworkProfile... networkProfiles) {
            networkProfiles(Arrays.asList(networkProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProfiles(Consumer<NetworkProfile.Builder>... networkProfiles) {
            networkProfiles(Stream.of(networkProfiles).map(c -> NetworkProfile.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkProfiles(Collection<NetworkProfile.BuilderImpl> networkProfiles) {
            this.networkProfiles = NetworkProfilesCopier.copyFromBuilder(networkProfiles);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListNetworkProfilesResponse build() {
            return new ListNetworkProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
