/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstanceProfilesResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListInstanceProfilesResponse.Builder, ListInstanceProfilesResponse> {
    private static final SdkField<List<InstanceProfile>> INSTANCE_PROFILES_FIELD = SdkField
            .<List<InstanceProfile>> builder(MarshallingType.LIST)
            .getter(getter(ListInstanceProfilesResponse::instanceProfiles))
            .setter(setter(Builder::instanceProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListInstanceProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_PROFILES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InstanceProfile> instanceProfiles;

    private final String nextToken;

    private ListInstanceProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceProfiles = builder.instanceProfiles;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the InstanceProfiles property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasInstanceProfiles() {
        return instanceProfiles != null && !(instanceProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains information about your instance profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceProfiles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object that contains information about your instance profiles.
     */
    public List<InstanceProfile> instanceProfiles() {
        return instanceProfiles;
    }

    /**
     * <p>
     * An identifier that can be used in the next call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return An identifier that can be used in the next call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceProfilesResponse)) {
            return false;
        }
        ListInstanceProfilesResponse other = (ListInstanceProfilesResponse) obj;
        return Objects.equals(instanceProfiles(), other.instanceProfiles()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListInstanceProfilesResponse").add("InstanceProfiles", instanceProfiles())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceProfiles":
            return Optional.ofNullable(clazz.cast(instanceProfiles()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstanceProfilesResponse, T> g) {
        return obj -> g.apply((ListInstanceProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInstanceProfilesResponse> {
        /**
         * <p>
         * An object that contains information about your instance profiles.
         * </p>
         * 
         * @param instanceProfiles
         *        An object that contains information about your instance profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfiles(Collection<InstanceProfile> instanceProfiles);

        /**
         * <p>
         * An object that contains information about your instance profiles.
         * </p>
         * 
         * @param instanceProfiles
         *        An object that contains information about your instance profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfiles(InstanceProfile... instanceProfiles);

        /**
         * <p>
         * An object that contains information about your instance profiles.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceProfile>.Builder} avoiding the need
         * to create one manually via {@link List<InstanceProfile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceProfile>.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceProfiles(List<InstanceProfile>)}.
         * 
         * @param instanceProfiles
         *        a consumer that will call methods on {@link List<InstanceProfile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceProfiles(List<InstanceProfile>)
         */
        Builder instanceProfiles(Consumer<InstanceProfile.Builder>... instanceProfiles);

        /**
         * <p>
         * An identifier that can be used in the next call to this operation to return the next set of items in the
         * list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that can be used in the next call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<InstanceProfile> instanceProfiles = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceProfilesResponse model) {
            super(model);
            instanceProfiles(model.instanceProfiles);
            nextToken(model.nextToken);
        }

        public final Collection<InstanceProfile.Builder> getInstanceProfiles() {
            return instanceProfiles != null ? instanceProfiles.stream().map(InstanceProfile::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceProfiles(Collection<InstanceProfile> instanceProfiles) {
            this.instanceProfiles = InstanceProfilesCopier.copy(instanceProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfiles(InstanceProfile... instanceProfiles) {
            instanceProfiles(Arrays.asList(instanceProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfiles(Consumer<InstanceProfile.Builder>... instanceProfiles) {
            instanceProfiles(Stream.of(instanceProfiles).map(c -> InstanceProfile.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceProfiles(Collection<InstanceProfile.BuilderImpl> instanceProfiles) {
            this.instanceProfiles = InstanceProfilesCopier.copyFromBuilder(instanceProfiles);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInstanceProfilesResponse build() {
            return new ListInstanceProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
