/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse;
import software.amazon.awssdk.services.devicefarm.model.OfferingTransaction;

public class ListOfferingTransactionsPublisher
implements SdkPublisher<ListOfferingTransactionsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListOfferingTransactionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOfferingTransactionsPublisher(DeviceFarmAsyncClient client, ListOfferingTransactionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOfferingTransactionsPublisher(DeviceFarmAsyncClient client, ListOfferingTransactionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOfferingTransactionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOfferingTransactionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OfferingTransaction> offeringTransactions() {
        Function<ListOfferingTransactionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.offeringTransactions() != null) {
                return response.offeringTransactions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOfferingTransactionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListOfferingTransactionsPublisher resume(ListOfferingTransactionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListOfferingTransactionsPublisher(this.client, (ListOfferingTransactionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListOfferingTransactionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListOfferingTransactionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListOfferingTransactionsResponseFetcher
    implements AsyncPageFetcher<ListOfferingTransactionsResponse> {
        private ListOfferingTransactionsResponseFetcher() {
        }

        public boolean hasNextPage(ListOfferingTransactionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOfferingTransactionsResponse> nextPage(ListOfferingTransactionsResponse previousPage) {
            if (previousPage == null) {
                return ListOfferingTransactionsPublisher.this.client.listOfferingTransactions(ListOfferingTransactionsPublisher.this.firstRequest);
            }
            return ListOfferingTransactionsPublisher.this.client.listOfferingTransactions((ListOfferingTransactionsRequest)((Object)ListOfferingTransactionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

