/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.TrialMinutes;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TrialMinutesMarshaller {
    private static final MarshallingInfo<Double> TOTAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("total").isBinary(false).build();
    private static final MarshallingInfo<Double> REMAINING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("remaining").isBinary(false).build();
    private static final TrialMinutesMarshaller INSTANCE = new TrialMinutesMarshaller();

    private TrialMinutesMarshaller() {
    }

    public static TrialMinutesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TrialMinutes trialMinutes, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)trialMinutes, (String)"trialMinutes");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)trialMinutes.total(), TOTAL_BINDING);
            protocolMarshaller.marshall((Object)trialMinutes.remaining(), REMAINING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

