/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.Sample;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SampleMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").isBinary(false).build();
    private static final SampleMarshaller INSTANCE = new SampleMarshaller();

    private SampleMarshaller() {
    }

    public static SampleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Sample sample, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sample, (String)"sample");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sample.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)sample.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)sample.url(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

