/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.Radios;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RadiosMarshaller {
    private static final MarshallingInfo<Boolean> WIFI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("wifi").isBinary(false).build();
    private static final MarshallingInfo<Boolean> BLUETOOTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bluetooth").isBinary(false).build();
    private static final MarshallingInfo<Boolean> NFC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nfc").isBinary(false).build();
    private static final MarshallingInfo<Boolean> GPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gps").isBinary(false).build();
    private static final RadiosMarshaller INSTANCE = new RadiosMarshaller();

    private RadiosMarshaller() {
    }

    public static RadiosMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Radios radios, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)radios, (String)"radios");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)radios.wifi(), WIFI_BINDING);
            protocolMarshaller.marshall((Object)radios.bluetooth(), BLUETOOTH_BINDING);
            protocolMarshaller.marshall((Object)radios.nfc(), NFC_BINDING);
            protocolMarshaller.marshall((Object)radios.gps(), GPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

