/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse;
import software.amazon.awssdk.services.devicefarm.model.Offering;

public class ListOfferingsPublisher
implements SdkPublisher<ListOfferingsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOfferingsPublisher(DeviceFarmAsyncClient client, ListOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOfferingsPublisher(DeviceFarmAsyncClient client, ListOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Offering> offerings() {
        Function<ListOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.offerings() != null) {
                return response.offerings().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListOfferingsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListOfferingsPublisher resume(ListOfferingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListOfferingsPublisher(this.client, (ListOfferingsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListOfferingsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListOfferingsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListOfferingsResponseFetcher
    implements AsyncPageFetcher<ListOfferingsResponse> {
        private ListOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(ListOfferingsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListOfferingsResponse> nextPage(ListOfferingsResponse previousPage) {
            if (previousPage == null) {
                return ListOfferingsPublisher.this.client.listOfferings(ListOfferingsPublisher.this.firstRequest);
            }
            return ListOfferingsPublisher.this.client.listOfferings((ListOfferingsRequest)((Object)ListOfferingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

