/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.Job;
import software.amazon.awssdk.services.devicefarm.model.ListJobsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListJobsResponse;

public class ListJobsIterable
implements SdkIterable<ListJobsResponse> {
    private final DeviceFarmClient client;
    private final ListJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobsIterable(DeviceFarmClient client, ListJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListJobsResponseFetcher();
    }

    public Iterator<ListJobsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Job> jobs() {
        Function<ListJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListJobsIterable resume(ListJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListJobsIterable(this.client, (ListJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListJobsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListJobsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListJobsResponseFetcher
    implements SyncPageFetcher<ListJobsResponse> {
        private ListJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListJobsResponse nextPage(ListJobsResponse previousPage) {
            if (previousPage == null) {
                return ListJobsIterable.this.client.listJobs(ListJobsIterable.this.firstRequest);
            }
            return ListJobsIterable.this.client.listJobs((ListJobsRequest)((Object)ListJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

