/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse;
import software.amazon.awssdk.services.devicefarm.model.Upload;

public final class ListUploadsPaginator
implements SdkIterable<ListUploadsResponse> {
    private final DeviceFarmClient client;
    private final ListUploadsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListUploadsPaginator(DeviceFarmClient client, ListUploadsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUploadsResponseFetcher();
    }

    public Iterator<ListUploadsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Upload> uploads() {
        Function<ListUploadsResponse, Iterator> getIterator = response -> response != null ? response.uploads().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListUploadsResponseFetcher
    implements NextPageFetcher<ListUploadsResponse> {
        private ListUploadsResponseFetcher() {
        }

        public boolean hasNextPage(ListUploadsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListUploadsResponse nextPage(ListUploadsResponse previousPage) {
            if (previousPage == null) {
                return ListUploadsPaginator.this.client.listUploads(ListUploadsPaginator.this.firstRequest);
            }
            return ListUploadsPaginator.this.client.listUploads((ListUploadsRequest)((Object)ListUploadsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

