/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.Artifact;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse;

public final class ListArtifactsPaginator
implements SdkIterable<ListArtifactsResponse> {
    private final DeviceFarmClient client;
    private final ListArtifactsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListArtifactsPaginator(DeviceFarmClient client, ListArtifactsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListArtifactsResponseFetcher();
    }

    public Iterator<ListArtifactsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Artifact> artifacts() {
        Function<ListArtifactsResponse, Iterator> getIterator = response -> response != null ? response.artifacts().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListArtifactsResponseFetcher
    implements NextPageFetcher<ListArtifactsResponse> {
        private ListArtifactsResponseFetcher() {
        }

        public boolean hasNextPage(ListArtifactsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListArtifactsResponse nextPage(ListArtifactsResponse previousPage) {
            if (previousPage == null) {
                return ListArtifactsPaginator.this.client.listArtifacts(ListArtifactsPaginator.this.firstRequest);
            }
            return ListArtifactsPaginator.this.client.listArtifacts((ListArtifactsRequest)((Object)ListArtifactsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

