/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.DevicePool;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse;

public final class ListDevicePoolsPaginator
implements SdkIterable<ListDevicePoolsResponse> {
    private final DeviceFarmClient client;
    private final ListDevicePoolsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListDevicePoolsPaginator(DeviceFarmClient client, ListDevicePoolsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDevicePoolsResponseFetcher();
    }

    public Iterator<ListDevicePoolsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DevicePool> devicePools() {
        Function<ListDevicePoolsResponse, Iterator> getIterator = response -> response != null ? response.devicePools().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListDevicePoolsResponseFetcher
    implements NextPageFetcher<ListDevicePoolsResponse> {
        private ListDevicePoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicePoolsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListDevicePoolsResponse nextPage(ListDevicePoolsResponse previousPage) {
            if (previousPage == null) {
                return ListDevicePoolsPaginator.this.client.listDevicePools(ListDevicePoolsPaginator.this.firstRequest);
            }
            return ListDevicePoolsPaginator.this.client.listDevicePools((ListDevicePoolsRequest)((Object)ListDevicePoolsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

