/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.Offering;
import software.amazon.awssdk.services.devicefarm.model.OfferingsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOfferingsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListOfferingsResponse> {
    private final List<Offering> offerings;
    private final String nextToken;

    private ListOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.offerings = builder.offerings;
        this.nextToken = builder.nextToken;
    }

    public List<Offering> offerings() {
        return this.offerings;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.offerings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingsResponse)) {
            return false;
        }
        ListOfferingsResponse other = (ListOfferingsResponse)((Object)obj);
        return Objects.equals(this.offerings(), other.offerings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.offerings() != null) {
            sb.append("Offerings: ").append(this.offerings()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offerings": {
                return Optional.of(clazz.cast(this.offerings()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<Offering> offerings;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingsResponse model) {
            this.offerings(model.offerings);
            this.nextToken(model.nextToken);
        }

        public final Collection<Offering.Builder> getOfferings() {
            return this.offerings != null ? (Collection)this.offerings.stream().map(Offering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder offerings(Collection<Offering> offerings) {
            this.offerings = OfferingsCopier.copy(offerings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offerings(Offering ... offerings) {
            this.offerings(Arrays.asList(offerings));
            return this;
        }

        public final void setOfferings(Collection<Offering.BuilderImpl> offerings) {
            this.offerings = OfferingsCopier.copyFromBuilder(offerings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOfferingsResponse build() {
            return new ListOfferingsResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, ListOfferingsResponse> {
        public Builder offerings(Collection<Offering> var1);

        public Builder offerings(Offering ... var1);

        public Builder nextToken(String var1);
    }
}

