/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionConfiguration;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateRemoteAccessSessionRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, CreateRemoteAccessSessionRequest> {
    private final String projectArn;
    private final String deviceArn;
    private final String sshPublicKey;
    private final Boolean remoteDebugEnabled;
    private final String name;
    private final String clientId;
    private final CreateRemoteAccessSessionConfiguration configuration;

    private CreateRemoteAccessSessionRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.deviceArn = builder.deviceArn;
        this.sshPublicKey = builder.sshPublicKey;
        this.remoteDebugEnabled = builder.remoteDebugEnabled;
        this.name = builder.name;
        this.clientId = builder.clientId;
        this.configuration = builder.configuration;
    }

    public String projectArn() {
        return this.projectArn;
    }

    public String deviceArn() {
        return this.deviceArn;
    }

    public String sshPublicKey() {
        return this.sshPublicKey;
    }

    public Boolean remoteDebugEnabled() {
        return this.remoteDebugEnabled;
    }

    public String name() {
        return this.name;
    }

    public String clientId() {
        return this.clientId;
    }

    public CreateRemoteAccessSessionConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDebugEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRemoteAccessSessionRequest)) {
            return false;
        }
        CreateRemoteAccessSessionRequest other = (CreateRemoteAccessSessionRequest)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.sshPublicKey(), other.sshPublicKey()) && Objects.equals(this.remoteDebugEnabled(), other.remoteDebugEnabled()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.configuration(), other.configuration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.projectArn() != null) {
            sb.append("ProjectArn: ").append(this.projectArn()).append(",");
        }
        if (this.deviceArn() != null) {
            sb.append("DeviceArn: ").append(this.deviceArn()).append(",");
        }
        if (this.sshPublicKey() != null) {
            sb.append("SshPublicKey: ").append(this.sshPublicKey()).append(",");
        }
        if (this.remoteDebugEnabled() != null) {
            sb.append("RemoteDebugEnabled: ").append(this.remoteDebugEnabled()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.clientId() != null) {
            sb.append("ClientId: ").append(this.clientId()).append(",");
        }
        if (this.configuration() != null) {
            sb.append("Configuration: ").append(this.configuration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.of(clazz.cast(this.projectArn()));
            }
            case "deviceArn": {
                return Optional.of(clazz.cast(this.deviceArn()));
            }
            case "sshPublicKey": {
                return Optional.of(clazz.cast(this.sshPublicKey()));
            }
            case "remoteDebugEnabled": {
                return Optional.of(clazz.cast(this.remoteDebugEnabled()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "clientId": {
                return Optional.of(clazz.cast(this.clientId()));
            }
            case "configuration": {
                return Optional.of(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String projectArn;
        private String deviceArn;
        private String sshPublicKey;
        private Boolean remoteDebugEnabled;
        private String name;
        private String clientId;
        private CreateRemoteAccessSessionConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRemoteAccessSessionRequest model) {
            this.projectArn(model.projectArn);
            this.deviceArn(model.deviceArn);
            this.sshPublicKey(model.sshPublicKey);
            this.remoteDebugEnabled(model.remoteDebugEnabled);
            this.name(model.name);
            this.clientId(model.clientId);
            this.configuration(model.configuration);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final Boolean getRemoteDebugEnabled() {
            return this.remoteDebugEnabled;
        }

        @Override
        public final Builder remoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
            return this;
        }

        public final void setRemoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final CreateRemoteAccessSessionConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(CreateRemoteAccessSessionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(CreateRemoteAccessSessionConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateRemoteAccessSessionRequest build() {
            return new CreateRemoteAccessSessionRequest(this);
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    CopyableBuilder<Builder, CreateRemoteAccessSessionRequest> {
        public Builder projectArn(String var1);

        public Builder deviceArn(String var1);

        public Builder sshPublicKey(String var1);

        public Builder remoteDebugEnabled(Boolean var1);

        public Builder name(String var1);

        public Builder clientId(String var1);

        public Builder configuration(CreateRemoteAccessSessionConfiguration var1);

        default public Builder configuration(Consumer<CreateRemoteAccessSessionConfiguration.Builder> configuration) {
            return this.configuration((CreateRemoteAccessSessionConfiguration)((CreateRemoteAccessSessionConfiguration.Builder)CreateRemoteAccessSessionConfiguration.builder().apply(configuration)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

