/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.TrialMinutesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TrialMinutes
implements StructuredPojo,
ToCopyableBuilder<Builder, TrialMinutes> {
    private final Double total;
    private final Double remaining;

    private TrialMinutes(BuilderImpl builder) {
        this.total = builder.total;
        this.remaining = builder.remaining;
    }

    public Double total() {
        return this.total;
    }

    public Double remaining() {
        return this.remaining;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        hashCode = 31 * hashCode + Objects.hashCode(this.remaining());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialMinutes)) {
            return false;
        }
        TrialMinutes other = (TrialMinutes)obj;
        return Objects.equals(this.total(), other.total()) && Objects.equals(this.remaining(), other.remaining());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.total() != null) {
            sb.append("Total: ").append(this.total()).append(",");
        }
        if (this.remaining() != null) {
            sb.append("Remaining: ").append(this.remaining()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "total": {
                return Optional.of(clazz.cast(this.total()));
            }
            case "remaining": {
                return Optional.of(clazz.cast(this.remaining()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrialMinutesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Double total;
        private Double remaining;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialMinutes model) {
            this.total(model.total);
            this.remaining(model.remaining);
        }

        public final Double getTotal() {
            return this.total;
        }

        @Override
        public final Builder total(Double total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Double total) {
            this.total = total;
        }

        public final Double getRemaining() {
            return this.remaining;
        }

        @Override
        public final Builder remaining(Double remaining) {
            this.remaining = remaining;
            return this;
        }

        public final void setRemaining(Double remaining) {
            this.remaining = remaining;
        }

        public TrialMinutes build() {
            return new TrialMinutes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TrialMinutes> {
        public Builder total(Double var1);

        public Builder remaining(Double var1);
    }
}

