/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.Device;
import software.amazon.awssdk.services.devicefarm.model.IncompatibilityMessage;
import software.amazon.awssdk.services.devicefarm.model.IncompatibilityMessagesCopier;
import software.amazon.awssdk.services.devicefarm.transform.DevicePoolCompatibilityResultMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DevicePoolCompatibilityResult
implements StructuredPojo,
ToCopyableBuilder<Builder, DevicePoolCompatibilityResult> {
    private final Device device;
    private final Boolean compatible;
    private final List<IncompatibilityMessage> incompatibilityMessages;

    private DevicePoolCompatibilityResult(BuilderImpl builder) {
        this.device = builder.device;
        this.compatible = builder.compatible;
        this.incompatibilityMessages = builder.incompatibilityMessages;
    }

    public Device device() {
        return this.device;
    }

    public Boolean compatible() {
        return this.compatible;
    }

    public List<IncompatibilityMessage> incompatibilityMessages() {
        return this.incompatibilityMessages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.compatible());
        hashCode = 31 * hashCode + Objects.hashCode(this.incompatibilityMessages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevicePoolCompatibilityResult)) {
            return false;
        }
        DevicePoolCompatibilityResult other = (DevicePoolCompatibilityResult)obj;
        return Objects.equals(this.device(), other.device()) && Objects.equals(this.compatible(), other.compatible()) && Objects.equals(this.incompatibilityMessages(), other.incompatibilityMessages());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.device() != null) {
            sb.append("Device: ").append(this.device()).append(",");
        }
        if (this.compatible() != null) {
            sb.append("Compatible: ").append(this.compatible()).append(",");
        }
        if (this.incompatibilityMessages() != null) {
            sb.append("IncompatibilityMessages: ").append(this.incompatibilityMessages()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "device": {
                return Optional.of(clazz.cast(this.device()));
            }
            case "compatible": {
                return Optional.of(clazz.cast(this.compatible()));
            }
            case "incompatibilityMessages": {
                return Optional.of(clazz.cast(this.incompatibilityMessages()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DevicePoolCompatibilityResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Device device;
        private Boolean compatible;
        private List<IncompatibilityMessage> incompatibilityMessages;

        private BuilderImpl() {
        }

        private BuilderImpl(DevicePoolCompatibilityResult model) {
            this.device(model.device);
            this.compatible(model.compatible);
            this.incompatibilityMessages(model.incompatibilityMessages);
        }

        public final Device.Builder getDevice() {
            return this.device != null ? this.device.toBuilder() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        public final Boolean getCompatible() {
            return this.compatible;
        }

        @Override
        public final Builder compatible(Boolean compatible) {
            this.compatible = compatible;
            return this;
        }

        public final void setCompatible(Boolean compatible) {
            this.compatible = compatible;
        }

        public final Collection<IncompatibilityMessage.Builder> getIncompatibilityMessages() {
            return this.incompatibilityMessages != null ? (Collection)this.incompatibilityMessages.stream().map(IncompatibilityMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder incompatibilityMessages(Collection<IncompatibilityMessage> incompatibilityMessages) {
            this.incompatibilityMessages = IncompatibilityMessagesCopier.copy(incompatibilityMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incompatibilityMessages(IncompatibilityMessage ... incompatibilityMessages) {
            this.incompatibilityMessages(Arrays.asList(incompatibilityMessages));
            return this;
        }

        public final void setIncompatibilityMessages(Collection<IncompatibilityMessage.BuilderImpl> incompatibilityMessages) {
            this.incompatibilityMessages = IncompatibilityMessagesCopier.copyFromBuilder(incompatibilityMessages);
        }

        public DevicePoolCompatibilityResult build() {
            return new DevicePoolCompatibilityResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DevicePoolCompatibilityResult> {
        public Builder device(Device var1);

        default public Builder device(Consumer<Device.Builder> device) {
            return this.device((Device)((Device.Builder)Device.builder().apply(device)).build());
        }

        public Builder compatible(Boolean var1);

        public Builder incompatibilityMessages(Collection<IncompatibilityMessage> var1);

        public Builder incompatibilityMessages(IncompatibilityMessage ... var1);
    }
}

