/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfileType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateNetworkProfileRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateNetworkProfileRequest> {
    private final String projectArn;
    private final String name;
    private final String description;
    private final String type;
    private final Long uplinkBandwidthBits;
    private final Long downlinkBandwidthBits;
    private final Long uplinkDelayMs;
    private final Long downlinkDelayMs;
    private final Long uplinkJitterMs;
    private final Long downlinkJitterMs;
    private final Integer uplinkLossPercent;
    private final Integer downlinkLossPercent;

    private CreateNetworkProfileRequest(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.uplinkBandwidthBits = builder.uplinkBandwidthBits;
        this.downlinkBandwidthBits = builder.downlinkBandwidthBits;
        this.uplinkDelayMs = builder.uplinkDelayMs;
        this.downlinkDelayMs = builder.downlinkDelayMs;
        this.uplinkJitterMs = builder.uplinkJitterMs;
        this.downlinkJitterMs = builder.downlinkJitterMs;
        this.uplinkLossPercent = builder.uplinkLossPercent;
        this.downlinkLossPercent = builder.downlinkLossPercent;
    }

    public String projectArn() {
        return this.projectArn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public NetworkProfileType type() {
        return NetworkProfileType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Long uplinkBandwidthBits() {
        return this.uplinkBandwidthBits;
    }

    public Long downlinkBandwidthBits() {
        return this.downlinkBandwidthBits;
    }

    public Long uplinkDelayMs() {
        return this.uplinkDelayMs;
    }

    public Long downlinkDelayMs() {
        return this.downlinkDelayMs;
    }

    public Long uplinkJitterMs() {
        return this.uplinkJitterMs;
    }

    public Long downlinkJitterMs() {
        return this.downlinkJitterMs;
    }

    public Integer uplinkLossPercent() {
        return this.uplinkLossPercent;
    }

    public Integer downlinkLossPercent() {
        return this.downlinkLossPercent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkBandwidthBits());
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkBandwidthBits());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkJitterMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkJitterMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkLossPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkLossPercent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkProfileRequest)) {
            return false;
        }
        CreateNetworkProfileRequest other = (CreateNetworkProfileRequest)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.uplinkBandwidthBits(), other.uplinkBandwidthBits()) && Objects.equals(this.downlinkBandwidthBits(), other.downlinkBandwidthBits()) && Objects.equals(this.uplinkDelayMs(), other.uplinkDelayMs()) && Objects.equals(this.downlinkDelayMs(), other.downlinkDelayMs()) && Objects.equals(this.uplinkJitterMs(), other.uplinkJitterMs()) && Objects.equals(this.downlinkJitterMs(), other.downlinkJitterMs()) && Objects.equals(this.uplinkLossPercent(), other.uplinkLossPercent()) && Objects.equals(this.downlinkLossPercent(), other.downlinkLossPercent());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.projectArn() != null) {
            sb.append("ProjectArn: ").append(this.projectArn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.uplinkBandwidthBits() != null) {
            sb.append("UplinkBandwidthBits: ").append(this.uplinkBandwidthBits()).append(",");
        }
        if (this.downlinkBandwidthBits() != null) {
            sb.append("DownlinkBandwidthBits: ").append(this.downlinkBandwidthBits()).append(",");
        }
        if (this.uplinkDelayMs() != null) {
            sb.append("UplinkDelayMs: ").append(this.uplinkDelayMs()).append(",");
        }
        if (this.downlinkDelayMs() != null) {
            sb.append("DownlinkDelayMs: ").append(this.downlinkDelayMs()).append(",");
        }
        if (this.uplinkJitterMs() != null) {
            sb.append("UplinkJitterMs: ").append(this.uplinkJitterMs()).append(",");
        }
        if (this.downlinkJitterMs() != null) {
            sb.append("DownlinkJitterMs: ").append(this.downlinkJitterMs()).append(",");
        }
        if (this.uplinkLossPercent() != null) {
            sb.append("UplinkLossPercent: ").append(this.uplinkLossPercent()).append(",");
        }
        if (this.downlinkLossPercent() != null) {
            sb.append("DownlinkLossPercent: ").append(this.downlinkLossPercent()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.of(clazz.cast(this.projectArn()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "uplinkBandwidthBits": {
                return Optional.of(clazz.cast(this.uplinkBandwidthBits()));
            }
            case "downlinkBandwidthBits": {
                return Optional.of(clazz.cast(this.downlinkBandwidthBits()));
            }
            case "uplinkDelayMs": {
                return Optional.of(clazz.cast(this.uplinkDelayMs()));
            }
            case "downlinkDelayMs": {
                return Optional.of(clazz.cast(this.downlinkDelayMs()));
            }
            case "uplinkJitterMs": {
                return Optional.of(clazz.cast(this.uplinkJitterMs()));
            }
            case "downlinkJitterMs": {
                return Optional.of(clazz.cast(this.downlinkJitterMs()));
            }
            case "uplinkLossPercent": {
                return Optional.of(clazz.cast(this.uplinkLossPercent()));
            }
            case "downlinkLossPercent": {
                return Optional.of(clazz.cast(this.downlinkLossPercent()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String projectArn;
        private String name;
        private String description;
        private String type;
        private Long uplinkBandwidthBits;
        private Long downlinkBandwidthBits;
        private Long uplinkDelayMs;
        private Long downlinkDelayMs;
        private Long uplinkJitterMs;
        private Long downlinkJitterMs;
        private Integer uplinkLossPercent;
        private Integer downlinkLossPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkProfileRequest model) {
            this.projectArn(model.projectArn);
            this.name(model.name);
            this.description(model.description);
            this.type(model.type);
            this.uplinkBandwidthBits(model.uplinkBandwidthBits);
            this.downlinkBandwidthBits(model.downlinkBandwidthBits);
            this.uplinkDelayMs(model.uplinkDelayMs);
            this.downlinkDelayMs(model.downlinkDelayMs);
            this.uplinkJitterMs(model.uplinkJitterMs);
            this.downlinkJitterMs(model.downlinkJitterMs);
            this.uplinkLossPercent(model.uplinkLossPercent);
            this.downlinkLossPercent(model.downlinkLossPercent);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NetworkProfileType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getUplinkBandwidthBits() {
            return this.uplinkBandwidthBits;
        }

        @Override
        public final Builder uplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
            return this;
        }

        public final void setUplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
        }

        public final Long getDownlinkBandwidthBits() {
            return this.downlinkBandwidthBits;
        }

        @Override
        public final Builder downlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
            return this;
        }

        public final void setDownlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
        }

        public final Long getUplinkDelayMs() {
            return this.uplinkDelayMs;
        }

        @Override
        public final Builder uplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
            return this;
        }

        public final void setUplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
        }

        public final Long getDownlinkDelayMs() {
            return this.downlinkDelayMs;
        }

        @Override
        public final Builder downlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
            return this;
        }

        public final void setDownlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
        }

        public final Long getUplinkJitterMs() {
            return this.uplinkJitterMs;
        }

        @Override
        public final Builder uplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
            return this;
        }

        public final void setUplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
        }

        public final Long getDownlinkJitterMs() {
            return this.downlinkJitterMs;
        }

        @Override
        public final Builder downlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
            return this;
        }

        public final void setDownlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
        }

        public final Integer getUplinkLossPercent() {
            return this.uplinkLossPercent;
        }

        @Override
        public final Builder uplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
            return this;
        }

        public final void setUplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
        }

        public final Integer getDownlinkLossPercent() {
            return this.downlinkLossPercent;
        }

        @Override
        public final Builder downlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
            return this;
        }

        public final void setDownlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
        }

        public CreateNetworkProfileRequest build() {
            return new CreateNetworkProfileRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateNetworkProfileRequest> {
        public Builder projectArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(NetworkProfileType var1);

        public Builder uplinkBandwidthBits(Long var1);

        public Builder downlinkBandwidthBits(Long var1);

        public Builder uplinkDelayMs(Long var1);

        public Builder downlinkDelayMs(Long var1);

        public Builder uplinkJitterMs(Long var1);

        public Builder downlinkJitterMs(Long var1);

        public Builder uplinkLossPercent(Integer var1);

        public Builder downlinkLossPercent(Integer var1);
    }
}

