/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.AmazonResourceNamesCopier;
import software.amazon.awssdk.services.devicefarm.model.BillingMethod;
import software.amazon.awssdk.services.devicefarm.model.Location;
import software.amazon.awssdk.services.devicefarm.model.Radios;
import software.amazon.awssdk.services.devicefarm.transform.ScheduleRunConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScheduleRunConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ScheduleRunConfiguration> {
    private final String extraDataPackageArn;
    private final String networkProfileArn;
    private final String locale;
    private final Location location;
    private final Radios radios;
    private final List<String> auxiliaryApps;
    private final String billingMethod;

    private ScheduleRunConfiguration(BuilderImpl builder) {
        this.extraDataPackageArn = builder.extraDataPackageArn;
        this.networkProfileArn = builder.networkProfileArn;
        this.locale = builder.locale;
        this.location = builder.location;
        this.radios = builder.radios;
        this.auxiliaryApps = builder.auxiliaryApps;
        this.billingMethod = builder.billingMethod;
    }

    public String extraDataPackageArn() {
        return this.extraDataPackageArn;
    }

    public String networkProfileArn() {
        return this.networkProfileArn;
    }

    public String locale() {
        return this.locale;
    }

    public Location location() {
        return this.location;
    }

    public Radios radios() {
        return this.radios;
    }

    public List<String> auxiliaryApps() {
        return this.auxiliaryApps;
    }

    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(this.billingMethod);
    }

    public String billingMethodString() {
        return this.billingMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.extraDataPackageArn() == null ? 0 : this.extraDataPackageArn().hashCode());
        hashCode = 31 * hashCode + (this.networkProfileArn() == null ? 0 : this.networkProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.locale() == null ? 0 : this.locale().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.radios() == null ? 0 : this.radios().hashCode());
        hashCode = 31 * hashCode + (this.auxiliaryApps() == null ? 0 : this.auxiliaryApps().hashCode());
        hashCode = 31 * hashCode + (this.billingMethodString() == null ? 0 : this.billingMethodString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunConfiguration)) {
            return false;
        }
        ScheduleRunConfiguration other = (ScheduleRunConfiguration)obj;
        if (other.extraDataPackageArn() == null ^ this.extraDataPackageArn() == null) {
            return false;
        }
        if (other.extraDataPackageArn() != null && !other.extraDataPackageArn().equals(this.extraDataPackageArn())) {
            return false;
        }
        if (other.networkProfileArn() == null ^ this.networkProfileArn() == null) {
            return false;
        }
        if (other.networkProfileArn() != null && !other.networkProfileArn().equals(this.networkProfileArn())) {
            return false;
        }
        if (other.locale() == null ^ this.locale() == null) {
            return false;
        }
        if (other.locale() != null && !other.locale().equals(this.locale())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.radios() == null ^ this.radios() == null) {
            return false;
        }
        if (other.radios() != null && !other.radios().equals(this.radios())) {
            return false;
        }
        if (other.auxiliaryApps() == null ^ this.auxiliaryApps() == null) {
            return false;
        }
        if (other.auxiliaryApps() != null && !other.auxiliaryApps().equals(this.auxiliaryApps())) {
            return false;
        }
        if (other.billingMethodString() == null ^ this.billingMethodString() == null) {
            return false;
        }
        return other.billingMethodString() == null || other.billingMethodString().equals(this.billingMethodString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.extraDataPackageArn() != null) {
            sb.append("ExtraDataPackageArn: ").append(this.extraDataPackageArn()).append(",");
        }
        if (this.networkProfileArn() != null) {
            sb.append("NetworkProfileArn: ").append(this.networkProfileArn()).append(",");
        }
        if (this.locale() != null) {
            sb.append("Locale: ").append(this.locale()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.radios() != null) {
            sb.append("Radios: ").append(this.radios()).append(",");
        }
        if (this.auxiliaryApps() != null) {
            sb.append("AuxiliaryApps: ").append(this.auxiliaryApps()).append(",");
        }
        if (this.billingMethodString() != null) {
            sb.append("BillingMethod: ").append(this.billingMethodString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "extraDataPackageArn": {
                return Optional.of(clazz.cast(this.extraDataPackageArn()));
            }
            case "networkProfileArn": {
                return Optional.of(clazz.cast(this.networkProfileArn()));
            }
            case "locale": {
                return Optional.of(clazz.cast(this.locale()));
            }
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "radios": {
                return Optional.of(clazz.cast(this.radios()));
            }
            case "auxiliaryApps": {
                return Optional.of(clazz.cast(this.auxiliaryApps()));
            }
            case "billingMethod": {
                return Optional.of(clazz.cast(this.billingMethodString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleRunConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String extraDataPackageArn;
        private String networkProfileArn;
        private String locale;
        private Location location;
        private Radios radios;
        private List<String> auxiliaryApps;
        private String billingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunConfiguration model) {
            this.extraDataPackageArn(model.extraDataPackageArn);
            this.networkProfileArn(model.networkProfileArn);
            this.locale(model.locale);
            this.location(model.location);
            this.radios(model.radios);
            this.auxiliaryApps(model.auxiliaryApps);
            this.billingMethod(model.billingMethod);
        }

        public final String getExtraDataPackageArn() {
            return this.extraDataPackageArn;
        }

        @Override
        public final Builder extraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
            return this;
        }

        public final void setExtraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
        }

        public final String getNetworkProfileArn() {
            return this.networkProfileArn;
        }

        @Override
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final Location.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final Radios.Builder getRadios() {
            return this.radios != null ? this.radios.toBuilder() : null;
        }

        @Override
        public final Builder radios(Radios radios) {
            this.radios = radios;
            return this;
        }

        public final void setRadios(Radios.BuilderImpl radios) {
            this.radios = radios != null ? radios.build() : null;
        }

        public final Collection<String> getAuxiliaryApps() {
            return this.auxiliaryApps;
        }

        @Override
        public final Builder auxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auxiliaryApps(String ... auxiliaryApps) {
            this.auxiliaryApps(Arrays.asList(auxiliaryApps));
            return this;
        }

        public final void setAuxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
        }

        public final String getBillingMethod() {
            return this.billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public ScheduleRunConfiguration build() {
            return new ScheduleRunConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduleRunConfiguration> {
        public Builder extraDataPackageArn(String var1);

        public Builder networkProfileArn(String var1);

        public Builder locale(String var1);

        public Builder location(Location var1);

        public Builder radios(Radios var1);

        public Builder auxiliaryApps(Collection<String> var1);

        public Builder auxiliaryApps(String ... var1);

        public Builder billingMethod(String var1);

        public Builder billingMethod(BillingMethod var1);
    }
}

