/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ProjectMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Project
implements StructuredPojo,
ToCopyableBuilder<Builder, Project> {
    private final String arn;
    private final String name;
    private final Integer defaultJobTimeoutMinutes;
    private final Instant created;

    private Project(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.defaultJobTimeoutMinutes = builder.defaultJobTimeoutMinutes;
        this.created = builder.created;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public Integer defaultJobTimeoutMinutes() {
        return this.defaultJobTimeoutMinutes;
    }

    public Instant created() {
        return this.created;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.defaultJobTimeoutMinutes() == null ? 0 : this.defaultJobTimeoutMinutes().hashCode());
        hashCode = 31 * hashCode + (this.created() == null ? 0 : this.created().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.defaultJobTimeoutMinutes() == null ^ this.defaultJobTimeoutMinutes() == null) {
            return false;
        }
        if (other.defaultJobTimeoutMinutes() != null && !other.defaultJobTimeoutMinutes().equals(this.defaultJobTimeoutMinutes())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        return other.created() == null || other.created().equals(this.created());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.defaultJobTimeoutMinutes() != null) {
            sb.append("DefaultJobTimeoutMinutes: ").append(this.defaultJobTimeoutMinutes()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "defaultJobTimeoutMinutes": {
                return Optional.of(clazz.cast(this.defaultJobTimeoutMinutes()));
            }
            case "created": {
                return Optional.of(clazz.cast(this.created()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private Integer defaultJobTimeoutMinutes;
        private Instant created;

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            this.arn(model.arn);
            this.name(model.name);
            this.defaultJobTimeoutMinutes(model.defaultJobTimeoutMinutes);
            this.created(model.created);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getDefaultJobTimeoutMinutes() {
            return this.defaultJobTimeoutMinutes;
        }

        @Override
        public final Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
            return this;
        }

        public final void setDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public Project build() {
            return new Project(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Project> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder defaultJobTimeoutMinutes(Integer var1);

        public Builder created(Instant var1);
    }
}

