/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.Artifact;
import software.amazon.awssdk.services.devicefarm.model.ArtifactsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListArtifactsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListArtifactsResponse> {
    private final List<Artifact> artifacts;
    private final String nextToken;

    private ListArtifactsResponse(BuilderImpl builder) {
        this.artifacts = builder.artifacts;
        this.nextToken = builder.nextToken;
    }

    public List<Artifact> artifacts() {
        return this.artifacts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.artifacts() == null ? 0 : this.artifacts().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArtifactsResponse)) {
            return false;
        }
        ListArtifactsResponse other = (ListArtifactsResponse)((Object)obj);
        if (other.artifacts() == null ^ this.artifacts() == null) {
            return false;
        }
        if (other.artifacts() != null && !other.artifacts().equals(this.artifacts())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.artifacts() != null) {
            sb.append("Artifacts: ").append(this.artifacts()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "artifacts": {
                return Optional.of(clazz.cast(this.artifacts()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Artifact> artifacts;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArtifactsResponse model) {
            this.artifacts(model.artifacts);
            this.nextToken(model.nextToken);
        }

        public final Collection<Artifact.Builder> getArtifacts() {
            return this.artifacts != null ? (Collection)this.artifacts.stream().map(Artifact::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder artifacts(Collection<Artifact> artifacts) {
            this.artifacts = ArtifactsCopier.copy(artifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(Artifact ... artifacts) {
            this.artifacts(Arrays.asList(artifacts));
            return this;
        }

        public final void setArtifacts(Collection<Artifact.BuilderImpl> artifacts) {
            this.artifacts = ArtifactsCopier.copyFromBuilder(artifacts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListArtifactsResponse build() {
            return new ListArtifactsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListArtifactsResponse> {
        public Builder artifacts(Collection<Artifact> var1);

        public Builder artifacts(Artifact ... var1);

        public Builder nextToken(String var1);
    }
}

