/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.Counters;
import software.amazon.awssdk.services.devicefarm.model.Device;
import software.amazon.awssdk.services.devicefarm.model.DeviceMinutes;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResult;
import software.amazon.awssdk.services.devicefarm.model.ExecutionStatus;
import software.amazon.awssdk.services.devicefarm.model.TestType;
import software.amazon.awssdk.services.devicefarm.transform.JobMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Job
implements StructuredPojo,
ToCopyableBuilder<Builder, Job> {
    private final String arn;
    private final String name;
    private final String type;
    private final Instant created;
    private final String status;
    private final String result;
    private final Instant started;
    private final Instant stopped;
    private final Counters counters;
    private final String message;
    private final Device device;
    private final DeviceMinutes deviceMinutes;

    private Job(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.counters = builder.counters;
        this.message = builder.message;
        this.device = builder.device;
        this.deviceMinutes = builder.deviceMinutes;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public TestType type() {
        return TestType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Instant created() {
        return this.created;
    }

    public ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public ExecutionResult result() {
        return ExecutionResult.fromValue(this.result);
    }

    public String resultString() {
        return this.result;
    }

    public Instant started() {
        return this.started;
    }

    public Instant stopped() {
        return this.stopped;
    }

    public Counters counters() {
        return this.counters;
    }

    public String message() {
        return this.message;
    }

    public Device device() {
        return this.device;
    }

    public DeviceMinutes deviceMinutes() {
        return this.deviceMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.created() == null ? 0 : this.created().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.resultString() == null ? 0 : this.resultString().hashCode());
        hashCode = 31 * hashCode + (this.started() == null ? 0 : this.started().hashCode());
        hashCode = 31 * hashCode + (this.stopped() == null ? 0 : this.stopped().hashCode());
        hashCode = 31 * hashCode + (this.counters() == null ? 0 : this.counters().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.device() == null ? 0 : this.device().hashCode());
        hashCode = 31 * hashCode + (this.deviceMinutes() == null ? 0 : this.deviceMinutes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        if (other.created() != null && !other.created().equals(this.created())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.resultString() == null ^ this.resultString() == null) {
            return false;
        }
        if (other.resultString() != null && !other.resultString().equals(this.resultString())) {
            return false;
        }
        if (other.started() == null ^ this.started() == null) {
            return false;
        }
        if (other.started() != null && !other.started().equals(this.started())) {
            return false;
        }
        if (other.stopped() == null ^ this.stopped() == null) {
            return false;
        }
        if (other.stopped() != null && !other.stopped().equals(this.stopped())) {
            return false;
        }
        if (other.counters() == null ^ this.counters() == null) {
            return false;
        }
        if (other.counters() != null && !other.counters().equals(this.counters())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        if (other.deviceMinutes() == null ^ this.deviceMinutes() == null) {
            return false;
        }
        return other.deviceMinutes() == null || other.deviceMinutes().equals(this.deviceMinutes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.resultString() != null) {
            sb.append("Result: ").append(this.resultString()).append(",");
        }
        if (this.started() != null) {
            sb.append("Started: ").append(this.started()).append(",");
        }
        if (this.stopped() != null) {
            sb.append("Stopped: ").append(this.stopped()).append(",");
        }
        if (this.counters() != null) {
            sb.append("Counters: ").append(this.counters()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.device() != null) {
            sb.append("Device: ").append(this.device()).append(",");
        }
        if (this.deviceMinutes() != null) {
            sb.append("DeviceMinutes: ").append(this.deviceMinutes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "created": {
                return Optional.of(clazz.cast(this.created()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "result": {
                return Optional.of(clazz.cast(this.resultString()));
            }
            case "started": {
                return Optional.of(clazz.cast(this.started()));
            }
            case "stopped": {
                return Optional.of(clazz.cast(this.stopped()));
            }
            case "counters": {
                return Optional.of(clazz.cast(this.counters()));
            }
            case "message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "device": {
                return Optional.of(clazz.cast(this.device()));
            }
            case "deviceMinutes": {
                return Optional.of(clazz.cast(this.deviceMinutes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String type;
        private Instant created;
        private String status;
        private String result;
        private Instant started;
        private Instant stopped;
        private Counters counters;
        private String message;
        private Device device;
        private DeviceMinutes deviceMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            this.arn(model.arn);
            this.name(model.name);
            this.type(model.type);
            this.created(model.created);
            this.status(model.status);
            this.result(model.result);
            this.started(model.started);
            this.stopped(model.stopped);
            this.counters(model.counters);
            this.message(model.message);
            this.device(model.device);
            this.deviceMinutes(model.deviceMinutes);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getResult() {
            return this.result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final Instant getStarted() {
            return this.started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        public final Instant getStopped() {
            return this.stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        public final Counters.Builder getCounters() {
            return this.counters != null ? this.counters.toBuilder() : null;
        }

        @Override
        public final Builder counters(Counters counters) {
            this.counters = counters;
            return this;
        }

        public final void setCounters(Counters.BuilderImpl counters) {
            this.counters = counters != null ? counters.build() : null;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Device.Builder getDevice() {
            return this.device != null ? this.device.toBuilder() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        public final DeviceMinutes.Builder getDeviceMinutes() {
            return this.deviceMinutes != null ? this.deviceMinutes.toBuilder() : null;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final void setDeviceMinutes(DeviceMinutes.BuilderImpl deviceMinutes) {
            this.deviceMinutes = deviceMinutes != null ? deviceMinutes.build() : null;
        }

        public Job build() {
            return new Job(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Job> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(TestType var1);

        public Builder created(Instant var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder result(String var1);

        public Builder result(ExecutionResult var1);

        public Builder started(Instant var1);

        public Builder stopped(Instant var1);

        public Builder counters(Counters var1);

        public Builder message(String var1);

        public Builder device(Device var1);

        public Builder deviceMinutes(DeviceMinutes var1);
    }
}

