/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.AccountSettings;

@SdkInternalApi
public class AccountSettingsMarshaller {
    private static final MarshallingInfo<String> AWSACCOUNTNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsAccountNumber").build();
    private static final MarshallingInfo<Map> UNMETEREDDEVICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unmeteredDevices").build();
    private static final MarshallingInfo<Map> UNMETEREDREMOTEACCESSDEVICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unmeteredRemoteAccessDevices").build();
    private static final MarshallingInfo<Integer> MAXJOBTIMEOUTMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxJobTimeoutMinutes").build();
    private static final MarshallingInfo<StructuredPojo> TRIALMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("trialMinutes").build();
    private static final MarshallingInfo<Map> MAXSLOTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxSlots").build();
    private static final MarshallingInfo<Integer> DEFAULTJOBTIMEOUTMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultJobTimeoutMinutes").build();
    private static final AccountSettingsMarshaller INSTANCE = new AccountSettingsMarshaller();

    public static AccountSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AccountSettings accountSettings, ProtocolMarshaller protocolMarshaller) {
        if (accountSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)accountSettings.awsAccountNumber(), AWSACCOUNTNUMBER_BINDING);
            protocolMarshaller.marshall(accountSettings.unmeteredDevices(), UNMETEREDDEVICES_BINDING);
            protocolMarshaller.marshall(accountSettings.unmeteredRemoteAccessDevices(), UNMETEREDREMOTEACCESSDEVICES_BINDING);
            protocolMarshaller.marshall((Object)accountSettings.maxJobTimeoutMinutes(), MAXJOBTIMEOUTMINUTES_BINDING);
            protocolMarshaller.marshall((Object)accountSettings.trialMinutes(), TRIALMINUTES_BINDING);
            protocolMarshaller.marshall(accountSettings.maxSlots(), MAXSLOTS_BINDING);
            protocolMarshaller.marshall((Object)accountSettings.defaultJobTimeoutMinutes(), DEFAULTJOBTIMEOUTMINUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

