/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.DevicePlatform;
import software.amazon.awssdk.services.devicefarm.model.OfferingType;
import software.amazon.awssdk.services.devicefarm.model.RecurringCharge;
import software.amazon.awssdk.services.devicefarm.model.RecurringChargesCopier;
import software.amazon.awssdk.services.devicefarm.transform.OfferingMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Offering
implements StructuredPojo,
ToCopyableBuilder<Builder, Offering> {
    private final String id;
    private final String description;
    private final String type;
    private final String platform;
    private final List<RecurringCharge> recurringCharges;

    private Offering(BuilderImpl builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.type = builder.type;
        this.platform = builder.platform;
        this.recurringCharges = builder.recurringCharges;
    }

    public String id() {
        return this.id;
    }

    public String description() {
        return this.description;
    }

    public String type() {
        return this.type;
    }

    public String platform() {
        return this.platform;
    }

    public List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        hashCode = 31 * hashCode + (this.recurringCharges() == null ? 0 : this.recurringCharges().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Offering)) {
            return false;
        }
        Offering other = (Offering)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.recurringCharges() == null ^ this.recurringCharges() == null) {
            return false;
        }
        return other.recurringCharges() == null || other.recurringCharges().equals(this.recurringCharges());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        if (this.recurringCharges() != null) {
            sb.append("RecurringCharges: ").append(this.recurringCharges()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OfferingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String description;
        private String type;
        private String platform;
        private List<RecurringCharge> recurringCharges;

        private BuilderImpl() {
        }

        private BuilderImpl(Offering model) {
            this.setId(model.id);
            this.setDescription(model.description);
            this.setType(model.type);
            this.setPlatform(model.platform);
            this.setRecurringCharges(model.recurringCharges);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OfferingType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(DevicePlatform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Collection<RecurringCharge> getRecurringCharges() {
            return this.recurringCharges;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesCopier.copy(recurringCharges);
        }

        public Offering build() {
            return new Offering(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Offering> {
        public Builder id(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(OfferingType var1);

        public Builder platform(String var1);

        public Builder platform(DevicePlatform var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);
    }
}

