/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.DevicePool;
import software.amazon.awssdk.services.devicefarm.model.DevicePoolsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDevicePoolsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDevicePoolsResponse> {
    private final List<DevicePool> devicePools;
    private final String nextToken;

    private ListDevicePoolsResponse(BuilderImpl builder) {
        this.devicePools = builder.devicePools;
        this.nextToken = builder.nextToken;
    }

    public List<DevicePool> devicePools() {
        return this.devicePools;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.devicePools() == null ? 0 : this.devicePools().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicePoolsResponse)) {
            return false;
        }
        ListDevicePoolsResponse other = (ListDevicePoolsResponse)((Object)obj);
        if (other.devicePools() == null ^ this.devicePools() == null) {
            return false;
        }
        if (other.devicePools() != null && !other.devicePools().equals(this.devicePools())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.devicePools() != null) {
            sb.append("DevicePools: ").append(this.devicePools()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DevicePool> devicePools;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicePoolsResponse model) {
            this.setDevicePools(model.devicePools);
            this.setNextToken(model.nextToken);
        }

        public final Collection<DevicePool> getDevicePools() {
            return this.devicePools;
        }

        @Override
        public final Builder devicePools(Collection<DevicePool> devicePools) {
            this.devicePools = DevicePoolsCopier.copy(devicePools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePools(DevicePool ... devicePools) {
            this.devicePools(Arrays.asList(devicePools));
            return this;
        }

        public final void setDevicePools(Collection<DevicePool> devicePools) {
            this.devicePools = DevicePoolsCopier.copy(devicePools);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDevicePoolsResponse build() {
            return new ListDevicePoolsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDevicePoolsResponse> {
        public Builder devicePools(Collection<DevicePool> var1);

        public Builder devicePools(DevicePool ... var1);

        public Builder nextToken(String var1);
    }
}

