/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.UniqueProblem;
import software.amazon.awssdk.services.devicefarm.model.UniqueProblemsByExecutionResultMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListUniqueProblemsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListUniqueProblemsResponse> {
    private final Map<String, List<UniqueProblem>> uniqueProblems;
    private final String nextToken;

    private ListUniqueProblemsResponse(BuilderImpl builder) {
        this.uniqueProblems = builder.uniqueProblems;
        this.nextToken = builder.nextToken;
    }

    public Map<String, List<UniqueProblem>> uniqueProblems() {
        return this.uniqueProblems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.uniqueProblems() == null ? 0 : this.uniqueProblems().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUniqueProblemsResponse)) {
            return false;
        }
        ListUniqueProblemsResponse other = (ListUniqueProblemsResponse)((Object)obj);
        if (other.uniqueProblems() == null ^ this.uniqueProblems() == null) {
            return false;
        }
        if (other.uniqueProblems() != null && !other.uniqueProblems().equals(this.uniqueProblems())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.uniqueProblems() != null) {
            sb.append("UniqueProblems: ").append(this.uniqueProblems()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, List<UniqueProblem>> uniqueProblems;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUniqueProblemsResponse model) {
            this.setUniqueProblems(model.uniqueProblems);
            this.setNextToken(model.nextToken);
        }

        public final Map<String, ? extends Collection<UniqueProblem>> getUniqueProblems() {
            return this.uniqueProblems;
        }

        @Override
        public final Builder uniqueProblems(Map<String, ? extends Collection<UniqueProblem>> uniqueProblems) {
            this.uniqueProblems = UniqueProblemsByExecutionResultMapCopier.copy(uniqueProblems);
            return this;
        }

        public final void setUniqueProblems(Map<String, ? extends Collection<UniqueProblem>> uniqueProblems) {
            this.uniqueProblems = UniqueProblemsByExecutionResultMapCopier.copy(uniqueProblems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListUniqueProblemsResponse build() {
            return new ListUniqueProblemsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListUniqueProblemsResponse> {
        public Builder uniqueProblems(Map<String, ? extends Collection<UniqueProblem>> var1);

        public Builder nextToken(String var1);
    }
}

