/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.UniqueProblem;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UniqueProblemMarshaller {
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").isBinary(false).build();
    private static final MarshallingInfo<List> PROBLEMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("problems").isBinary(false).build();
    private static final UniqueProblemMarshaller INSTANCE = new UniqueProblemMarshaller();

    private UniqueProblemMarshaller() {
    }

    public static UniqueProblemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UniqueProblem uniqueProblem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)uniqueProblem, (String)"uniqueProblem");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)uniqueProblem.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall(uniqueProblem.problems(), PROBLEMS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

