/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ScheduleRunConfigurationMarshaller {
    private static final MarshallingInfo<String> EXTRADATAPACKAGEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("extraDataPackageArn").isBinary(false).build();
    private static final MarshallingInfo<String> NETWORKPROFILEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkProfileArn").isBinary(false).build();
    private static final MarshallingInfo<String> LOCALE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("locale").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final MarshallingInfo<List> VPCECONFIGURATIONARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpceConfigurationArns").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CUSTOMERARTIFACTPATHS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerArtifactPaths").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RADIOS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("radios").isBinary(false).build();
    private static final MarshallingInfo<List> AUXILIARYAPPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("auxiliaryApps").isBinary(false).build();
    private static final MarshallingInfo<String> BILLINGMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("billingMethod").isBinary(false).build();
    private static final ScheduleRunConfigurationMarshaller INSTANCE = new ScheduleRunConfigurationMarshaller();

    private ScheduleRunConfigurationMarshaller() {
    }

    public static ScheduleRunConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ScheduleRunConfiguration scheduleRunConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)scheduleRunConfiguration, (String)"scheduleRunConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)scheduleRunConfiguration.extraDataPackageArn(), EXTRADATAPACKAGEARN_BINDING);
            protocolMarshaller.marshall((Object)scheduleRunConfiguration.networkProfileArn(), NETWORKPROFILEARN_BINDING);
            protocolMarshaller.marshall((Object)scheduleRunConfiguration.locale(), LOCALE_BINDING);
            protocolMarshaller.marshall((Object)scheduleRunConfiguration.location(), LOCATION_BINDING);
            protocolMarshaller.marshall(scheduleRunConfiguration.vpceConfigurationArns(), VPCECONFIGURATIONARNS_BINDING);
            protocolMarshaller.marshall((Object)scheduleRunConfiguration.customerArtifactPaths(), CUSTOMERARTIFACTPATHS_BINDING);
            protocolMarshaller.marshall((Object)scheduleRunConfiguration.radios(), RADIOS_BINDING);
            protocolMarshaller.marshall(scheduleRunConfiguration.auxiliaryApps(), AUXILIARYAPPS_BINDING);
            protocolMarshaller.marshall((Object)scheduleRunConfiguration.billingMethodAsString(), BILLINGMETHOD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

