/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.OfferingTransaction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OfferingTransactionMarshaller {
    private static final MarshallingInfo<StructuredPojo> OFFERINGSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("offeringStatus").isBinary(false).build();
    private static final MarshallingInfo<String> TRANSACTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transactionId").isBinary(false).build();
    private static final MarshallingInfo<String> OFFERINGPROMOTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("offeringPromotionId").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdOn").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cost").isBinary(false).build();
    private static final OfferingTransactionMarshaller INSTANCE = new OfferingTransactionMarshaller();

    private OfferingTransactionMarshaller() {
    }

    public static OfferingTransactionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OfferingTransaction offeringTransaction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)offeringTransaction, (String)"offeringTransaction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)offeringTransaction.offeringStatus(), OFFERINGSTATUS_BINDING);
            protocolMarshaller.marshall((Object)offeringTransaction.transactionId(), TRANSACTIONID_BINDING);
            protocolMarshaller.marshall((Object)offeringTransaction.offeringPromotionId(), OFFERINGPROMOTIONID_BINDING);
            protocolMarshaller.marshall((Object)offeringTransaction.createdOn(), CREATEDON_BINDING);
            protocolMarshaller.marshall((Object)offeringTransaction.cost(), COST_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

