/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.devicefarm.model.TestParametersCopier;
import software.amazon.awssdk.services.devicefarm.model.TestType;
import software.amazon.awssdk.services.devicefarm.transform.ScheduleRunTestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleRunTest
implements StructuredPojo,
ToCopyableBuilder<Builder, ScheduleRunTest> {
    private final String type;
    private final String testPackageArn;
    private final String testSpecArn;
    private final String filter;
    private final Map<String, String> parameters;

    private ScheduleRunTest(BuilderImpl builder) {
        this.type = builder.type;
        this.testPackageArn = builder.testPackageArn;
        this.testSpecArn = builder.testSpecArn;
        this.filter = builder.filter;
        this.parameters = builder.parameters;
    }

    public TestType type() {
        return TestType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String testPackageArn() {
        return this.testPackageArn;
    }

    public String testSpecArn() {
        return this.testSpecArn;
    }

    public String filter() {
        return this.filter;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.testPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSpecArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunTest)) {
            return false;
        }
        ScheduleRunTest other = (ScheduleRunTest)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.testPackageArn(), other.testPackageArn()) && Objects.equals(this.testSpecArn(), other.testSpecArn()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.parameters(), other.parameters());
    }

    public String toString() {
        return ToString.builder((String)"ScheduleRunTest").add("Type", (Object)this.typeAsString()).add("TestPackageArn", (Object)this.testPackageArn()).add("TestSpecArn", (Object)this.testSpecArn()).add("Filter", (Object)this.filter()).add("Parameters", this.parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "testPackageArn": {
                return Optional.ofNullable(clazz.cast(this.testPackageArn()));
            }
            case "testSpecArn": {
                return Optional.ofNullable(clazz.cast(this.testSpecArn()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleRunTestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String testPackageArn;
        private String testSpecArn;
        private String filter;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunTest model) {
            this.type(model.type);
            this.testPackageArn(model.testPackageArn);
            this.testSpecArn(model.testSpecArn);
            this.filter(model.filter);
            this.parameters(model.parameters);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTestPackageArn() {
            return this.testPackageArn;
        }

        @Override
        public final Builder testPackageArn(String testPackageArn) {
            this.testPackageArn = testPackageArn;
            return this;
        }

        public final void setTestPackageArn(String testPackageArn) {
            this.testPackageArn = testPackageArn;
        }

        public final String getTestSpecArn() {
            return this.testSpecArn;
        }

        @Override
        public final Builder testSpecArn(String testSpecArn) {
            this.testSpecArn = testSpecArn;
            return this;
        }

        public final void setTestSpecArn(String testSpecArn) {
            this.testSpecArn = testSpecArn;
        }

        public final String getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = TestParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = TestParametersCopier.copy(parameters);
        }

        public ScheduleRunTest build() {
            return new ScheduleRunTest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduleRunTest> {
        public Builder type(String var1);

        public Builder type(TestType var1);

        public Builder testPackageArn(String var1);

        public Builder testSpecArn(String var1);

        public Builder filter(String var1);

        public Builder parameters(Map<String, String> var1);
    }
}

