/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpceConfigurationRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, CreateVpceConfigurationRequest> {
    private final String vpceConfigurationName;
    private final String vpceServiceName;
    private final String serviceDnsName;
    private final String vpceConfigurationDescription;

    private CreateVpceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.vpceConfigurationName = builder.vpceConfigurationName;
        this.vpceServiceName = builder.vpceServiceName;
        this.serviceDnsName = builder.serviceDnsName;
        this.vpceConfigurationDescription = builder.vpceConfigurationDescription;
    }

    public String vpceConfigurationName() {
        return this.vpceConfigurationName;
    }

    public String vpceServiceName() {
        return this.vpceServiceName;
    }

    public String serviceDnsName() {
        return this.serviceDnsName;
    }

    public String vpceConfigurationDescription() {
        return this.vpceConfigurationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpceConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpceServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpceConfigurationDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpceConfigurationRequest)) {
            return false;
        }
        CreateVpceConfigurationRequest other = (CreateVpceConfigurationRequest)((Object)obj);
        return Objects.equals(this.vpceConfigurationName(), other.vpceConfigurationName()) && Objects.equals(this.vpceServiceName(), other.vpceServiceName()) && Objects.equals(this.serviceDnsName(), other.serviceDnsName()) && Objects.equals(this.vpceConfigurationDescription(), other.vpceConfigurationDescription());
    }

    public String toString() {
        return ToString.builder((String)"CreateVpceConfigurationRequest").add("VpceConfigurationName", (Object)this.vpceConfigurationName()).add("VpceServiceName", (Object)this.vpceServiceName()).add("ServiceDnsName", (Object)this.serviceDnsName()).add("VpceConfigurationDescription", (Object)this.vpceConfigurationDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vpceConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.vpceConfigurationName()));
            }
            case "vpceServiceName": {
                return Optional.ofNullable(clazz.cast(this.vpceServiceName()));
            }
            case "serviceDnsName": {
                return Optional.ofNullable(clazz.cast(this.serviceDnsName()));
            }
            case "vpceConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.vpceConfigurationDescription()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String vpceConfigurationName;
        private String vpceServiceName;
        private String serviceDnsName;
        private String vpceConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpceConfigurationRequest model) {
            super(model);
            this.vpceConfigurationName(model.vpceConfigurationName);
            this.vpceServiceName(model.vpceServiceName);
            this.serviceDnsName(model.serviceDnsName);
            this.vpceConfigurationDescription(model.vpceConfigurationDescription);
        }

        public final String getVpceConfigurationName() {
            return this.vpceConfigurationName;
        }

        @Override
        public final Builder vpceConfigurationName(String vpceConfigurationName) {
            this.vpceConfigurationName = vpceConfigurationName;
            return this;
        }

        public final void setVpceConfigurationName(String vpceConfigurationName) {
            this.vpceConfigurationName = vpceConfigurationName;
        }

        public final String getVpceServiceName() {
            return this.vpceServiceName;
        }

        @Override
        public final Builder vpceServiceName(String vpceServiceName) {
            this.vpceServiceName = vpceServiceName;
            return this;
        }

        public final void setVpceServiceName(String vpceServiceName) {
            this.vpceServiceName = vpceServiceName;
        }

        public final String getServiceDnsName() {
            return this.serviceDnsName;
        }

        @Override
        public final Builder serviceDnsName(String serviceDnsName) {
            this.serviceDnsName = serviceDnsName;
            return this;
        }

        public final void setServiceDnsName(String serviceDnsName) {
            this.serviceDnsName = serviceDnsName;
        }

        public final String getVpceConfigurationDescription() {
            return this.vpceConfigurationDescription;
        }

        @Override
        public final Builder vpceConfigurationDescription(String vpceConfigurationDescription) {
            this.vpceConfigurationDescription = vpceConfigurationDescription;
            return this;
        }

        public final void setVpceConfigurationDescription(String vpceConfigurationDescription) {
            this.vpceConfigurationDescription = vpceConfigurationDescription;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpceConfigurationRequest build() {
            return new CreateVpceConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    CopyableBuilder<Builder, CreateVpceConfigurationRequest> {
        public Builder vpceConfigurationName(String var1);

        public Builder vpceServiceName(String var1);

        public Builder serviceDnsName(String var1);

        public Builder vpceConfigurationDescription(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

