/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.ExecutionConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExecutionConfigurationMarshaller {
    private static final MarshallingInfo<Integer> JOBTIMEOUTMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobTimeoutMinutes").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ACCOUNTSCLEANUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountsCleanup").isBinary(false).build();
    private static final MarshallingInfo<Boolean> APPPACKAGESCLEANUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("appPackagesCleanup").isBinary(false).build();
    private static final ExecutionConfigurationMarshaller INSTANCE = new ExecutionConfigurationMarshaller();

    private ExecutionConfigurationMarshaller() {
    }

    public static ExecutionConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExecutionConfiguration executionConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)executionConfiguration, (String)"executionConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)executionConfiguration.jobTimeoutMinutes(), JOBTIMEOUTMINUTES_BINDING);
            protocolMarshaller.marshall((Object)executionConfiguration.accountsCleanup(), ACCOUNTSCLEANUP_BINDING);
            protocolMarshaller.marshall((Object)executionConfiguration.appPackagesCleanup(), APPPACKAGESCLEANUP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

