/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateNetworkProfileRequestModelMarshaller {
    private static final MarshallingInfo<String> PROJECTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("projectArn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<Long> UPLINKBANDWIDTHBITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uplinkBandwidthBits").isBinary(false).build();
    private static final MarshallingInfo<Long> DOWNLINKBANDWIDTHBITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("downlinkBandwidthBits").isBinary(false).build();
    private static final MarshallingInfo<Long> UPLINKDELAYMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uplinkDelayMs").isBinary(false).build();
    private static final MarshallingInfo<Long> DOWNLINKDELAYMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("downlinkDelayMs").isBinary(false).build();
    private static final MarshallingInfo<Long> UPLINKJITTERMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uplinkJitterMs").isBinary(false).build();
    private static final MarshallingInfo<Long> DOWNLINKJITTERMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("downlinkJitterMs").isBinary(false).build();
    private static final MarshallingInfo<Integer> UPLINKLOSSPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uplinkLossPercent").isBinary(false).build();
    private static final MarshallingInfo<Integer> DOWNLINKLOSSPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("downlinkLossPercent").isBinary(false).build();
    private static final CreateNetworkProfileRequestModelMarshaller INSTANCE = new CreateNetworkProfileRequestModelMarshaller();

    private CreateNetworkProfileRequestModelMarshaller() {
    }

    public static CreateNetworkProfileRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateNetworkProfileRequest createNetworkProfileRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createNetworkProfileRequest), (String)"createNetworkProfileRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createNetworkProfileRequest.projectArn(), PROJECTARN_BINDING);
            protocolMarshaller.marshall((Object)createNetworkProfileRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createNetworkProfileRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createNetworkProfileRequest.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)createNetworkProfileRequest.uplinkBandwidthBits(), UPLINKBANDWIDTHBITS_BINDING);
            protocolMarshaller.marshall((Object)createNetworkProfileRequest.downlinkBandwidthBits(), DOWNLINKBANDWIDTHBITS_BINDING);
            protocolMarshaller.marshall((Object)createNetworkProfileRequest.uplinkDelayMs(), UPLINKDELAYMS_BINDING);
            protocolMarshaller.marshall((Object)createNetworkProfileRequest.downlinkDelayMs(), DOWNLINKDELAYMS_BINDING);
            protocolMarshaller.marshall((Object)createNetworkProfileRequest.uplinkJitterMs(), UPLINKJITTERMS_BINDING);
            protocolMarshaller.marshall((Object)createNetworkProfileRequest.downlinkJitterMs(), DOWNLINKJITTERMS_BINDING);
            protocolMarshaller.marshall((Object)createNetworkProfileRequest.uplinkLossPercent(), UPLINKLOSSPERCENT_BINDING);
            protocolMarshaller.marshall((Object)createNetworkProfileRequest.downlinkLossPercent(), DOWNLINKLOSSPERCENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

