/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.devicefarm.model.AccountSettings;
import software.amazon.awssdk.services.devicefarm.transform.TrialMinutesUnmarshaller;

public class AccountSettingsUnmarshaller
implements Unmarshaller<AccountSettings, JsonUnmarshallerContext> {
    private static final AccountSettingsUnmarshaller INSTANCE = new AccountSettingsUnmarshaller();

    public AccountSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        AccountSettings.Builder accountSettingsBuilder = AccountSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("awsAccountNumber", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.awsAccountNumber((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("unmeteredDevices", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.unmeteredDevicesWithStrings(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(Integer.class)).unmarshall(context));
                }
                if (context.testExpression("unmeteredRemoteAccessDevices", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.unmeteredRemoteAccessDevicesWithStrings(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(Integer.class)).unmarshall(context));
                }
                if (context.testExpression("maxJobTimeoutMinutes", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.maxJobTimeoutMinutes((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("trialMinutes", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.trialMinutes(TrialMinutesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("maxSlots", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.maxSlots(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(Integer.class)).unmarshall(context));
                }
                if (context.testExpression("defaultJobTimeoutMinutes", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.defaultJobTimeoutMinutes((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AccountSettings)accountSettingsBuilder.build();
    }

    public static AccountSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

