/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse;
import software.amazon.awssdk.services.devicefarm.model.Project;

public class ListProjectsIterable
implements SdkIterable<ListProjectsResponse> {
    private final DeviceFarmClient client;
    private final ListProjectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProjectsIterable(DeviceFarmClient client, ListProjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProjectsResponseFetcher();
    }

    public Iterator<ListProjectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Project> projects() {
        Function<ListProjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.projects() != null) {
                return response.projects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListProjectsIterable resume(ListProjectsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListProjectsIterable(this.client, (ListProjectsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListProjectsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListProjectsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListProjectsResponseFetcher
    implements SyncPageFetcher<ListProjectsResponse> {
        private ListProjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListProjectsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListProjectsResponse nextPage(ListProjectsResponse previousPage) {
            if (previousPage == null) {
                return ListProjectsIterable.this.client.listProjects(ListProjectsIterable.this.firstRequest);
            }
            return ListProjectsIterable.this.client.listProjects((ListProjectsRequest)((Object)ListProjectsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

