/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse;
import software.amazon.awssdk.services.devicefarm.model.Offering;

public class ListOfferingsIterable
implements SdkIterable<ListOfferingsResponse> {
    private final DeviceFarmClient client;
    private final ListOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOfferingsIterable(DeviceFarmClient client, ListOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOfferingsResponseFetcher();
    }

    public Iterator<ListOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Offering> offerings() {
        Function<ListOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.offerings() != null) {
                return response.offerings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListOfferingsIterable resume(ListOfferingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListOfferingsIterable(this.client, (ListOfferingsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListOfferingsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListOfferingsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListOfferingsResponseFetcher
    implements SyncPageFetcher<ListOfferingsResponse> {
        private ListOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(ListOfferingsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListOfferingsResponse nextPage(ListOfferingsResponse previousPage) {
            if (previousPage == null) {
                return ListOfferingsIterable.this.client.listOfferings(ListOfferingsIterable.this.firstRequest);
            }
            return ListOfferingsIterable.this.client.listOfferings((ListOfferingsRequest)((Object)ListOfferingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

