/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.DeviceMinutesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceMinutes
implements StructuredPojo,
ToCopyableBuilder<Builder, DeviceMinutes> {
    private final Double total;
    private final Double metered;
    private final Double unmetered;

    private DeviceMinutes(BuilderImpl builder) {
        this.total = builder.total;
        this.metered = builder.metered;
        this.unmetered = builder.unmetered;
    }

    public Double total() {
        return this.total;
    }

    public Double metered() {
        return this.metered;
    }

    public Double unmetered() {
        return this.unmetered;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        hashCode = 31 * hashCode + Objects.hashCode(this.metered());
        hashCode = 31 * hashCode + Objects.hashCode(this.unmetered());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceMinutes)) {
            return false;
        }
        DeviceMinutes other = (DeviceMinutes)obj;
        return Objects.equals(this.total(), other.total()) && Objects.equals(this.metered(), other.metered()) && Objects.equals(this.unmetered(), other.unmetered());
    }

    public String toString() {
        return ToString.builder((String)"DeviceMinutes").add("Total", (Object)this.total()).add("Metered", (Object)this.metered()).add("Unmetered", (Object)this.unmetered()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
            case "metered": {
                return Optional.ofNullable(clazz.cast(this.metered()));
            }
            case "unmetered": {
                return Optional.ofNullable(clazz.cast(this.unmetered()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceMinutesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Double total;
        private Double metered;
        private Double unmetered;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceMinutes model) {
            this.total(model.total);
            this.metered(model.metered);
            this.unmetered(model.unmetered);
        }

        public final Double getTotal() {
            return this.total;
        }

        @Override
        public final Builder total(Double total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Double total) {
            this.total = total;
        }

        public final Double getMetered() {
            return this.metered;
        }

        @Override
        public final Builder metered(Double metered) {
            this.metered = metered;
            return this;
        }

        public final void setMetered(Double metered) {
            this.metered = metered;
        }

        public final Double getUnmetered() {
            return this.unmetered;
        }

        @Override
        public final Builder unmetered(Double unmetered) {
            this.unmetered = unmetered;
            return this;
        }

        public final void setUnmetered(Double unmetered) {
            this.unmetered = unmetered;
        }

        public DeviceMinutes build() {
            return new DeviceMinutes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeviceMinutes> {
        public Builder total(Double var1);

        public Builder metered(Double var1);

        public Builder unmetered(Double var1);
    }
}

