/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse;
import software.amazon.awssdk.services.devicefarm.model.OfferingStatus;

public class GetOfferingStatusIterable
implements SdkIterable<GetOfferingStatusResponse> {
    private final DeviceFarmClient client;
    private final GetOfferingStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetOfferingStatusIterable(DeviceFarmClient client, GetOfferingStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetOfferingStatusResponseFetcher();
    }

    public Iterator<GetOfferingStatusResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Map.Entry<String, OfferingStatus>> current() {
        Function<GetOfferingStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.current() != null) {
                return response.current().entrySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final SdkIterable<Map.Entry<String, OfferingStatus>> nextPeriod() {
        Function<GetOfferingStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.nextPeriod() != null) {
                return response.nextPeriod().entrySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final GetOfferingStatusIterable resume(GetOfferingStatusResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetOfferingStatusIterable(this.client, (GetOfferingStatusRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetOfferingStatusIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetOfferingStatusResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetOfferingStatusResponseFetcher
    implements SyncPageFetcher<GetOfferingStatusResponse> {
        private GetOfferingStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetOfferingStatusResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetOfferingStatusResponse nextPage(GetOfferingStatusResponse previousPage) {
            if (previousPage == null) {
                return GetOfferingStatusIterable.this.client.getOfferingStatus(GetOfferingStatusIterable.this.firstRequest);
            }
            return GetOfferingStatusIterable.this.client.getOfferingStatus((GetOfferingStatusRequest)((Object)GetOfferingStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

