/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.MonetaryAmount;
import software.amazon.awssdk.services.devicefarm.model.RecurringChargeFrequency;
import software.amazon.awssdk.services.devicefarm.transform.RecurringChargeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecurringCharge
implements StructuredPojo,
ToCopyableBuilder<Builder, RecurringCharge> {
    private final MonetaryAmount cost;
    private final String frequency;

    private RecurringCharge(BuilderImpl builder) {
        this.cost = builder.cost;
        this.frequency = builder.frequency;
    }

    public MonetaryAmount cost() {
        return this.cost;
    }

    public RecurringChargeFrequency frequency() {
        return RecurringChargeFrequency.fromValue(this.frequency);
    }

    public String frequencyAsString() {
        return this.frequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cost());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringCharge)) {
            return false;
        }
        RecurringCharge other = (RecurringCharge)obj;
        return Objects.equals(this.cost(), other.cost()) && Objects.equals(this.frequencyAsString(), other.frequencyAsString());
    }

    public String toString() {
        return ToString.builder((String)"RecurringCharge").add("Cost", (Object)this.cost()).add("Frequency", (Object)this.frequencyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cost": {
                return Optional.of(clazz.cast(this.cost()));
            }
            case "frequency": {
                return Optional.of(clazz.cast(this.frequencyAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecurringChargeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private MonetaryAmount cost;
        private String frequency;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurringCharge model) {
            this.cost(model.cost);
            this.frequency(model.frequency);
        }

        public final MonetaryAmount.Builder getCost() {
            return this.cost != null ? this.cost.toBuilder() : null;
        }

        @Override
        public final Builder cost(MonetaryAmount cost) {
            this.cost = cost;
            return this;
        }

        public final void setCost(MonetaryAmount.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(RecurringChargeFrequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public RecurringCharge build() {
            return new RecurringCharge(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecurringCharge> {
        public Builder cost(MonetaryAmount var1);

        default public Builder cost(Consumer<MonetaryAmount.Builder> cost) {
            return this.cost((MonetaryAmount)((MonetaryAmount.Builder)MonetaryAmount.builder().apply(cost)).build());
        }

        public Builder frequency(String var1);

        public Builder frequency(RecurringChargeFrequency var1);
    }
}

