/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.Suite;
import software.amazon.awssdk.services.devicefarm.model.SuitesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSuitesResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListSuitesResponse> {
    private final List<Suite> suites;
    private final String nextToken;

    private ListSuitesResponse(BuilderImpl builder) {
        super(builder);
        this.suites = builder.suites;
        this.nextToken = builder.nextToken;
    }

    public List<Suite> suites() {
        return this.suites;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.suites());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuitesResponse)) {
            return false;
        }
        ListSuitesResponse other = (ListSuitesResponse)((Object)obj);
        return Objects.equals(this.suites(), other.suites()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSuitesResponse").add("Suites", this.suites()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "suites": {
                return Optional.of(clazz.cast(this.suites()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<Suite> suites;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSuitesResponse model) {
            super(model);
            this.suites(model.suites);
            this.nextToken(model.nextToken);
        }

        public final Collection<Suite.Builder> getSuites() {
            return this.suites != null ? (Collection)this.suites.stream().map(Suite::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder suites(Collection<Suite> suites) {
            this.suites = SuitesCopier.copy(suites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suites(Suite ... suites) {
            this.suites(Arrays.asList(suites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suites(Consumer<Suite.Builder> ... suites) {
            this.suites(Stream.of(suites).map(c -> (Suite)((Suite.Builder)Suite.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuites(Collection<Suite.BuilderImpl> suites) {
            this.suites = SuitesCopier.copyFromBuilder(suites);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSuitesResponse build() {
            return new ListSuitesResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, ListSuitesResponse> {
        public Builder suites(Collection<Suite> var1);

        public Builder suites(Suite ... var1);

        public Builder suites(Consumer<Suite.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

